/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.repository;

import gov.llnl.babel.parsers.xml.ParseSymbolException;
import gov.llnl.babel.parsers.xml.ParseSymbolXML;
import gov.llnl.babel.parsers.xml.SymbolToDOM;
import gov.llnl.babel.repository.Repository;
import gov.llnl.babel.repository.RepositoryException;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.url.CookieConnection;
import gov.llnl.babel.url.HttpException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Set;
import org.xml.sax.InputSource;

public class WebRepository
implements Repository {
    private String d_web_url;
    private CookieConnection d_connection;
    private static final String LOGIN_PATH = "alexandria/jsp/entry.jsp";
    private static final String SIDL_PATH = "alexandria/type";

    public WebRepository(String repository) throws RepositoryException {
        int u_index = repository.indexOf("?username=");
        int p_index = repository.indexOf("&password=");
        if (u_index < 0 || p_index <= u_index) {
            throw new RepositoryException("Invalid format for username and password (http://www.machine.org/?username=USERNAME&password=PASSWORD)");
        }
        this.d_web_url = repository.substring(0, u_index);
        if (!this.d_web_url.endsWith("/")) {
            this.d_web_url = this.d_web_url + "/";
        }
        String username = repository.substring(u_index + 10, p_index);
        String password = repository.substring(p_index + 10);
        this.d_connection = new CookieConnection();
        this.login(username, password);
    }

    private void login(String username, String password) throws RepositoryException {
        StringBuffer payload = new StringBuffer();
        payload.append("name=");
        payload.append(URLEncoder.encode(username));
        payload.append("&password=");
        payload.append(URLEncoder.encode(password));
        payload.append("&machine=true");
        try {
            this.d_connection.postToURL(this.d_web_url + LOGIN_PATH, "application/x-www-form-urlencoded", new ByteArrayInputStream(payload.toString().getBytes()));
        }
        catch (HttpException ex) {
            throw new RepositoryException("Unable to log into web repository (check username and password)");
        }
        catch (IOException ex) {
            throw new RepositoryException("I/O error: " + ex.getMessage());
        }
    }

    public Symbol lookupSymbol(SymbolID id) {
        StringBuffer url = new StringBuffer();
        url.append(this.d_web_url);
        url.append(SIDL_PATH);
        url.append("/");
        url.append(URLEncoder.encode(id.getFullName()));
        url.append("?version=");
        url.append(URLEncoder.encode(id.getVersion().getVersionString()));
        return this.parseSymbolURL(url.toString());
    }

    public Symbol lookupSymbol(String fqn) {
        StringBuffer url = new StringBuffer();
        url.append(this.d_web_url);
        url.append(SIDL_PATH);
        url.append("/");
        url.append(URLEncoder.encode(fqn));
        return this.parseSymbolURL(url.toString());
    }

    private Symbol parseSymbolURL(String url) {
        Symbol symbol = null;
        try {
            InputStream istream = this.d_connection.getFromURL(url);
            symbol = ParseSymbolXML.convert(new InputSource(istream));
            istream.close();
        }
        catch (IOException ex) {
        }
        catch (ParseSymbolException ex) {
            // empty catch block
        }
        return symbol;
    }

    public void writeSymbols(Set symbol_names) throws RepositoryException {
        Iterator i = symbol_names.iterator();
        while (i.hasNext()) {
            this.writeSymbol((SymbolID)i.next());
        }
    }

    private void writeSymbol(SymbolID id) throws RepositoryException {
        Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
        if (symbol == null) {
            throw new RepositoryException("Symbol \"" + id.getSymbolName() + "\" not found in symbol table");
        }
        String xml = SymbolToDOM.convertToString(symbol);
        try {
            this.d_connection.postToURL(this.d_web_url + SIDL_PATH, "application/xml", new ByteArrayInputStream(xml.getBytes()));
        }
        catch (HttpException ex) {
            String msg = null;
            switch (ex.getResponseCode()) {
                case 400: {
                    msg = "Post does not match symbol DTD";
                    break;
                }
                case 409: {
                    msg = "Symbol conflicts with existing one in database";
                    break;
                }
                case 500: {
                    msg = "Server error (web server or SQL database)";
                    break;
                }
                default: {
                    msg = ex.getMessage();
                }
            }
            throw new RepositoryException(id.getSymbolName() + ": " + msg);
        }
        catch (IOException ex) {
            throw new RepositoryException(id.getSymbolName() + ": " + ex.getMessage());
        }
    }

    static {
        LOGIN_PATH = LOGIN_PATH;
        SIDL_PATH = SIDL_PATH;
    }
}

