/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Version {
    private ArrayList d_version = new ArrayList();

    public Version() {
    }

    public Version(String version) throws NumberFormatException {
        if ("0".equals(version)) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(version, ".");
        while (tokens.hasMoreTokens()) {
            Integer part = null;
            try {
                part = new Integer(tokens.nextToken());
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("Invalid integer in version \"" + ex.getMessage() + "\"");
            }
            if (part < 0) {
                throw new NumberFormatException("Negative integer in version \"" + version + "\"");
            }
            this.d_version.add(part);
        }
    }

    public void appendVersionNumber(int v) {
        if (v < 0) {
            throw new NumberFormatException("Negative value in version \"" + String.valueOf(v) + "\"");
        }
        this.d_version.add(new Integer(v));
    }

    public String getVersionString() {
        StringBuffer buffer = new StringBuffer();
        int size = this.d_version.size();
        if (size == 0) {
            buffer.append("0");
        } else {
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    buffer.append(".");
                }
                buffer.append(((Integer)this.d_version.get(i)).toString());
                ++i;
            }
        }
        return buffer.toString();
    }

    public int getVersionLength() {
        return this.d_version.size();
    }

    public boolean isUnspecified() {
        return this.d_version.size() == 0;
    }

    public int getVersionNumberAt(int i) {
        if (i < 0 || i >= this.d_version.size()) {
            return 0;
        }
        return (Integer)this.d_version.get(i);
    }

    public boolean isSame(Version other) {
        int b;
        int a = this.getVersionLength();
        int m = a > (b = other.getVersionLength()) ? a : b;
        int i = 0;
        while (i < m) {
            if (this.getVersionNumberAt(i) != other.getVersionNumberAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGreaterThan(Version other) {
        int b;
        int a = this.getVersionLength();
        int m = a > (b = other.getVersionLength()) ? a : b;
        int i = 0;
        while (i < m) {
            if (this.getVersionNumberAt(i) > other.getVersionNumberAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int lastNonzero = this.d_version.size();
        while (lastNonzero > 0 && (Integer)this.d_version.get(lastNonzero - 1) != 0) {
            --lastNonzero;
        }
        int i = 0;
        while (i < lastNonzero) {
            int digit = (Integer)this.d_version.get(i);
            int g = (h = (h << 4) + digit) & 0xF0000000;
            if (g != 0) {
                h ^= g >>> 24;
                h ^= g;
            }
            ++i;
        }
        return h;
    }
}

