/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.url.cookie;

import gov.llnl.babel.url.cookie.Cookie;
import gov.llnl.babel.url.cookie.CookieCrumbleException;
import gov.llnl.babel.url.cookie.CookieJar;
import gov.llnl.babel.url.cookie.Lexer;
import gov.llnl.babel.url.cookie.LexicalException;
import gov.llnl.babel.url.cookie.Token;
import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;

public class Http {
    private static Cookie parseNameValue(Lexer lex) throws IOException, LexicalException, CookieCrumbleException {
        Token value;
        Token equal;
        Token name = lex.nextToken();
        if (name.getType() == 1 && (equal = lex.nextToken()).getType() == 61 && ((value = lex.nextToken()).getType() == 1 || value.getType() == 2)) {
            return new Cookie(name.getText(), value.getText());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Token parseAttribute(Cookie cookie, Lexer lex, HttpURLConnection conn) throws IOException, LexicalException, CookieCrumbleException {
        Token attr = lex.nextToken();
        if (attr.getType() != 1) return attr;
        if (attr.getText().equals("Discard")) {
            cookie.setDiscardable(true);
            return lex.nextToken();
        } else if (attr.getText().equals("Secure")) {
            cookie.setSecure(true);
            return lex.nextToken();
        } else {
            Token equal = lex.nextToken();
            if (equal.getType() == 61) {
                Token value = lex.nextToken();
                if (value.getType() != 1 && value.getType() != 2) return null;
                if (attr.getText().equals("Domain")) {
                    if (value.getText().startsWith(".")) {
                        cookie.setDomain(value.getText());
                        return lex.nextToken();
                    } else {
                        cookie.setDomain("." + value.getText());
                    }
                    return lex.nextToken();
                } else if (attr.getText().equals("Max-Age")) {
                    cookie.setDomain(value.getText());
                    return lex.nextToken();
                } else if (attr.getText().equals("Path")) {
                    cookie.setPath(value.getText());
                    return lex.nextToken();
                } else if (attr.getText().equals("Version")) {
                    cookie.setVersion(value.getText());
                    return lex.nextToken();
                } else if (attr.getText().equals("Port") && value.getType() == 2) {
                    cookie.setPorts(value.getText());
                    return lex.nextToken();
                } else if (attr.getText().equals("Comment")) {
                    cookie.setComment(value.getText());
                    return lex.nextToken();
                } else {
                    if (!attr.getText().equals("CommentURL")) return lex.nextToken();
                    cookie.setUrlComment(value.getText());
                }
                return lex.nextToken();
            } else {
                if (!attr.getText().equals("Port")) return equal;
                cookie.setPorts(Integer.toString(conn.getURL().getPort()));
                return equal;
            }
        }
    }

    public static void sendCookies(URLConnection conn, CookieJar jar) throws IOException {
        URL url = conn.getURL();
        Iterator cookies = jar.getRelevantCookies(url.getHost(), url.getFile(), url.getPort());
        if (cookies != null && cookies.hasNext()) {
            StringBuffer cookieValue = new StringBuffer();
            cookieValue.append("$Version=\"1\";");
            while (cookies.hasNext()) {
                Cookie c = (Cookie)cookies.next();
                cookieValue.append(c.toString());
                if (!cookies.hasNext()) continue;
                cookieValue.append(';');
            }
            conn.setRequestProperty("Cookie", cookieValue.toString());
        }
    }

    public static void gleanCookies(HttpURLConnection conn, CookieJar jar) {
        String cookieSrc = conn.getHeaderField("Set-Cookie2");
        URL url = conn.getURL();
        String hostname = url.getHost();
        String filename = url.getFile();
        int port = url.getPort();
        if (cookieSrc != null) {
            Lexer lex = new Lexer(new StringReader(cookieSrc));
            try {
                Token tok;
                do {
                    Cookie cookie;
                    if ((cookie = Http.parseNameValue(lex)) != null) {
                        int lastSeparator;
                        tok = lex.nextToken();
                        while (tok != null && tok.getType() == 59) {
                            tok = Http.parseAttribute(cookie, lex, conn);
                        }
                        if (cookie.getDomain() == null) {
                            cookie.setDomain(Cookie.effectiveHostname(hostname));
                        }
                        if (cookie.getPath() == null && (lastSeparator = filename.lastIndexOf(47)) >= 0) {
                            cookie.setPath(filename.substring(0, lastSeparator + 1));
                        }
                        if (!cookie.hasValidDomain(hostname) || !cookie.isRelevant(hostname, filename, port)) continue;
                        jar.add(cookie);
                        continue;
                    }
                    tok = null;
                } while (tok != null && tok.getType() == 44);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (LexicalException le) {
                le.printStackTrace();
            }
            catch (CookieCrumbleException cce) {
                cce.printStackTrace();
            }
        }
    }
}

