//
// File:        TestParseXML.java
// Package:     gov.llnl.babel.parsers.xml
// Release:     $Name: release-0-8-8 $
// Revision:    @(#) $Id: TestParseXML.java,v 1.5 2003/05/30 22:04:14 epperly Exp $
// Description: unit test for the XML to symbol parser routines
//
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.parsers.xml;

import gov.llnl.babel.parsers.xml.ParseSymbolException;
import gov.llnl.babel.parsers.xml.ParseSymbolXML;
import gov.llnl.babel.parsers.xml.SymbolToDOM;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/**
 * Class <code>TestParseXML</code> is a simple unit test for the routines
 * that parse XML and return a SIDL <code>Symbol</code>.  The input URI
 * is parsed into a symbol, converted into a DOM representation, and then
 * output to the standard output.  The main routine takes one argument,
 * the URI of a XML symbol document.
 */
public class TestParseXML {

   /**
    * Method <code>main</code> is the entry point for the unit test.
    * The main routine expects only one argument, the URI of a XML
    * symbol document.
    */
   public static void main(String argv[]) {
      if (argv.length != 1) {
         System.err.println("gov.llnl.babel.parsers.xml.TestParseXML URI");
         System.exit(1);
      }

      try {
         Symbol symbol = ParseSymbolXML.convert(new InputSource(argv[0]));
         Document document = SymbolToDOM.convert(symbol);
         System.out.println(XMLUtilities.getXMLString(document));
      } catch (ParseSymbolException ex) {
	 System.err.println("Babel: Error: ParseSymbolException");
         System.err.println(ex.getMessage());
         ex.printStackTrace();
         System.exit(1);
      }
   }
}
