// excepttest.cc

#include <iostream>
#include <string>
using namespace std;
#include "ExceptionTest.hh"
using namespace ExceptionTest;

void test_string( int * part_no, int * final_result );
void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );

const char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED"  };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

#define MYPASS( AAA ) \
  cout << "COMMENT: " <<  AAA << endl; \
  result = pass; \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  cout << "COMMENT: " << AAA << endl; \
  result = xfail; \
  end_part( part_no, result, &final_result );

#define MYFAIL( AAA ) \
  cout << "COMMENT: " << AAA << endl; \
  result = fail; \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  cout << "COMMENT: " << AAA << endl; \
  end_part( part_no, unsupported, &final_result );

int main() { 
  int part_no = 0;
  int final_result = pass;
  int result = pass;
  Fib fib = Fib::_create();

  cout << "NPARTS 4" << endl;
  try { 
    declare_part( &part_no );
    fib.getFib(10,25,200,0);
    MYPASS( "no exception thrown (none expected)" );
  } catch (...) { 
    MYFAIL("unexpected exception thrown");
  }

  try { 
    declare_part( &part_no );
    fib.getFib(-1,10,10,0);    
    MYFAIL( "no exception thrown (NegativeValueException expected)" );
  } catch ( NegativeValueException ex ) { 
    MYPASS( "NegativeValueException thrown (as expected)" );
  } catch ( ... ) { 
    MYFAIL( "unexpected exception thrown" );
  }
 
  try { 
    declare_part( &part_no );
    fib.getFib(10,1,1000,0);
    MYFAIL( "no exception thrown (TooDeepException expected)" );    
  } catch ( TooDeepException ex ) { 
    MYFAIL( "TooDeepException thrown (and unexpectedly caught!)");
  } catch ( FibException ex ) { // catch declared types
    TooDeepException ex2 = ex;  // downcast
    if ( !ex2 ) { 
      MYFAIL( "FibException caught, but cannot cast to TooDeepException" );
    } else { 
      MYPASS( "FibException caught, and correctly cast to TooDeepException" );
    }
  } catch( ... ) { 
    MYFAIL( "unexpected exception thrown" );
  }

  try { 
    declare_part( &part_no );
    fib.getFib(10,1000,1,0);
    MYFAIL( "no exception thrown (TooBigException expected)" );    
  } catch ( TooBigException ex ) { 
    MYFAIL( "TooBigException thrown (and unexpectedly caught!)");
  } catch ( FibException ex ) { // catch declared types
    TooBigException ex2 = ex;  // downcast
    if ( !ex2 ) { 
      MYFAIL( "FibException caught, but cannot cast to TooBigException" );
    } else { 
      MYPASS( "FibException caught, and correctly cast to TooBigException" );
    }  
  } catch( ... ) { 
    MYFAIL( "unexpected exception thrown" );
  }

  cout << "TEST_RESULT " << result_string[ final_result ] << endl;
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  cout << "PART " << *part_no << endl;
}

void end_part( int part_no, int result, int *final_result ) {
  cout << "RESULT " << part_no << " " << result_string[ result ] << endl;
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

