C     
C File:        inherittest.f
C Copyright:   (c) 2001 The Regents of the University of California
C Release:     $Name: release-0-8-8 $
C Revision:    $Revision: 1.10 $
C Date:        $Date: 2003/03/19 00:29:07 $
C Description: Regression test to test FORTRAN calls to BABEL
C
      subroutine castcheck(partno, numpassed, sourcename,
     $     destname, pointer)
      implicit none
      integer partno, numpassed
      character *(*) sourcename, destname
      integer*8 pointer
      partno = partno + 1
      write (*,100) 'PART', partno
      write (*,110) 'COMMENT: Casting ', sourcename, ' to ',
     $     destname
      if (pointer .ne. 0) then
         write (*, 120) 'RESULT ', partno, ' PASS'
         numpassed = numpassed + 1
      else
         write (*, 120) 'RESULT ', partno, ' FAIL'
      endif
 100  format (a, i3)
 110  format (a, a, a, a)
 120  format (a, i3, a)
      end
      

      subroutine reporttest(partno, numpassed, methodname,
     $     expectedresult, result)
      implicit none
      integer partno, numpassed
      character *(*) methodname, expectedresult, result
      partno = partno + 1
      write (*, 100) 'PART ', partno
      write (*, 110) 'COMMENT: Method Inherit_', methodname,
     $     ' should return ', expectedresult
      write (*, 110) 'COMMENT: Method Inherit_', methodname,
     $     ' returned ', result
      if (result .eq. expectedresult) then
         numpassed = numpassed + 1
         write (*, 120) 'RESULT ', partno, ' PASS'
      else
         write (*, 120) 'RESULT ', partno, ' FAIL'
      endif
 100  format (a, i3)
 110  format (a, a, a, a)
 120  format (a, i3, a)
      end

      program inherittest
      implicit none
      integer partno, numpassed
      integer*8 object, altobject, interface
      character*32 strresult
      partno = 0
      numpassed = 0

      write (*, 110) 'NPARTS -1'
      call Inherit_C__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class C:'
      write (*,110) ' '
      call Inherit_C_c_f(object,strresult)
      call reporttest(partno, numpassed, 'C_c', 'C.c', strresult)
      call Inherit_C_deleteRef_f(object)

      call Inherit_D__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class D: inheritance of interface A'
      write (*,110) ' '
      call Inherit_D_a_f(object,strresult)
      call reporttest(partno, numpassed, 'D_a', 'D.a', strresult)
      write (*,110) ' '
      call Inherit_D_d_f(object,strresult)
      call reporttest(partno, numpassed, 'D_d', 'D.d', strresult)
      
      write (*,110) ' '
      write (*,110) 'Class D: via interface A'
      write (*,110) ' '
      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class D',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, numpassed, 'A_a', 'D.a', strresult)
         interface = 0
      endif
      call Inherit_D_deleteRef_f(object)

      call Inherit_E__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class E: inheritance of class C'
      write (*,110) ' '
      call Inherit_E_c_f(object,strresult)
      call reporttest(partno, numpassed, 'E_c', 'C.c', strresult)
      write (*,110) ' '
      call Inherit_E_e_f(object,strresult)
      call reporttest(partno, numpassed, 'E_e', 'E.e', strresult)

      write (*,110) ' '
      write (*,110) 'Class E: via class C (C.c not overridden)'
      write (*,110) ' '
      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class E',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, numpassed, 'C_c', 'C.c', strresult)
         altobject = 0
      endif
      call Inherit_E_deleteRef_f(object)

      call Inherit_E2__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class E2: inheritance of class C'
      write (*,110) ' '
      call Inherit_E2_c_f(object,strresult)
      call reporttest(partno, numpassed, 'E2_c', 'E2.c', strresult)
      write (*,110) ' '
      call Inherit_E2_e_f(object,strresult)
      call reporttest(partno, numpassed, 'E2_e', 'E2.e', strresult)

      write (*, 110) ' '
      write (*, 110) 'Class E2: via class C (C.c overridden)'
      write (*, 110) ' '
      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class E2',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, numpassed, 'C_c', 'E2.c', strresult)
         altobject = 0
      endif
      call Inherit_E2_deleteRef_f(object)

      call Inherit_F__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class F: Multiple inheritance (no overriding)'
      write (*,110) ' '
      call Inherit_F_a_f(object,strresult)
      call reporttest(partno, numpassed, 'F_a', 'F.a', strresult)
      write (*,110) ' '
      call Inherit_F_b_f(object,strresult)
      call reporttest(partno, numpassed, 'F_b', 'F.b', strresult)
      write (*,110) ' '
      call Inherit_F_c_f(object,strresult)
      call reporttest(partno, numpassed, 'F_c', 'C.c', strresult)
      write (*,110) ' '
      call Inherit_F_f_f(object,strresult)
      call reporttest(partno, numpassed, 'F_f', 'F.f', strresult)
      write (*,110) ' '
      write (*,110) 'Class F: via interface A'
      write (*,110) ' '
      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class F',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, numpassed, 'A_a', 'F.a', strresult)
         interface = 0
      endif

      write (*,110) ' '
      write (*,110) 'Class F: via interface B'
      write (*,110) ' '
      call Inherit_B__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class F',
     $     'Interface B', interface)
      if (interface .ne. 0) then
         call Inherit_B_b_f(interface,strresult)
         call reporttest(partno, numpassed, 'B_b', 'F.b', strresult)
         interface = 0
      endif

      write (*,110) ' '
      write (*,110) 'Class F: via class C (no overloading of C.c)'
      write (*,110) ' '
      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class F',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, numpassed, 'C_c', 'C.c', strresult)
         altobject = 0
      endif
      write (*,110) ' '

      call Inherit_F_deleteRef_f(object)

      call Inherit_F2__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class F2: Multiple inheritance (overrides C.c)'
      write (*,110) ' '
      call Inherit_F2_a_f(object,strresult)
      call reporttest(partno, numpassed, 'F2_a', 'F2.a', strresult)
      write (*,110) ' '
      call Inherit_F2_b_f(object,strresult)
      call reporttest(partno, numpassed, 'F2_b', 'F2.b', strresult)
      write (*,110) ' '
      call Inherit_F2_c_f(object,strresult)
      call reporttest(partno, numpassed, 'F2_c', 'F2.c', strresult)
      write (*,110) ' '
      call Inherit_F2_f_f(object,strresult)
      call reporttest(partno, numpassed, 'F2_f', 'F2.f', strresult)
      write (*,110) ' '
      
      write (*,110) ' '
      write (*,110) 'Class F2: via interface A'
      write (*,110) ' '
      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class F2',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, numpassed, 'A_a', 'F2.a', strresult)
         interface = 0
      endif

      write (*,110) ' '
      write (*,110) 'Class F2: via interface B'
      write (*,110) ' '
      call Inherit_B__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class F2',
     $     'Interface B', interface)
      if (interface .ne. 0) then
         call Inherit_B_b_f(interface,strresult)
         call reporttest(partno, numpassed, 'B_b', 'F2.b', strresult)
         interface = 0
      endif

      write (*,110) ' '
      write (*,110) 'Class F2: via class C (overloads C.c)'
      write (*,110) ' '
      call Inherit_C__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class F2',
     $     'Class C', altobject)
      if (altobject .ne. 0) then
         call Inherit_C_c_f(altobject,strresult)
         call reporttest(partno, numpassed, 'C_c', 'F2.c', strresult)
         altobject = 0
      endif
      write (*,110) ' '

      call Inherit_F2_deleteRef_f(object)

      write (*,110) ' '
      write (*,110)
     $     'Class G: indirect multiple inheritance (no overloads)'
      write (*,110) ' '
      call Inherit_G__create_f(object)
      call Inherit_G_a_f(object,strresult)
      call reporttest(partno, numpassed, 'G_a', 'D.a', strresult)
      write (*,110) ' '
      call Inherit_G_d_f(object,strresult)
      call reporttest(partno, numpassed, 'G_d', 'D.d', strresult)
      write (*,110) ' '
      call Inherit_G_g_f(object,strresult)
      call reporttest(partno, numpassed, 'G_g', 'G.g', strresult)
      write (*,110) ' '

      write (*,110) 'Class G: via interface A'
      write (*,110) ' '
      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class G',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, numpassed, 'A_a', 'D.a', strresult)
         interface = 0
      endif
      write (*,110) ' '
      write (*,110) 'Class G: via class D'
      write (*,110) ' '
      call Inherit_D__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class G',
     $     'Class D', altobject)
      if (altobject .ne. 0) then
         call Inherit_D_a_f(altobject,strresult)
         call reporttest(partno, numpassed, 'D_a', 'D.a', strresult)
         write (*,110) ' '
         write (*,110) ' '
         call Inherit_D_d_f(altobject,strresult)
         call reporttest(partno, numpassed, 'D_d', 'D.d', strresult)
         altobject = 0
      endif
      write (*,110) ' '

      call Inherit_G_deleteRef_f(object)

      write (*,110) ' '
      write (*,110)
     $     'Class G2: indirect multiple inheritance (overloads)'
      write (*,110) ' '
      call Inherit_G2__create_f(object)
      call Inherit_G2_a_f(object,strresult)
      call reporttest(partno, numpassed, 'G2_a', 'G2.a', strresult)
      write (*,110) ' '
      call Inherit_G2_d_f(object,strresult)
      call reporttest(partno, numpassed, 'G2_d', 'G2.d', strresult)
      write (*,110) ' '
      call Inherit_G2_g_f(object,strresult)
      call reporttest(partno, numpassed, 'G2_g', 'G2.g', strresult)
      write (*,110) ' '

      write (*,110) 'Class G2: via interface A'
      write (*,110) ' '
      call Inherit_A__cast_f(object, interface)
      call castcheck(partno, numpassed, 'Class G2',
     $     'Interface A', interface)
      if (interface .ne. 0) then
         call Inherit_A_a_f(interface,strresult)
         call reporttest(partno, numpassed, 'A_a', 'G2.a', strresult)
         interface = 0
      endif

      write (*,110) ' '
      write (*,110) 'Class G2: via class D'
      write (*,110) ' '
      call Inherit_D__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class G2',
     $     'Class D', altobject)
      if (altobject .ne. 0) then
         call Inherit_D_a_f(altobject,strresult)
         call reporttest(partno, numpassed, 'D_a', 'G2.a', strresult)
         write (*,110) ' '
         write (*,110) ' '
         call Inherit_D_d_f(altobject,strresult)
         call reporttest(partno, numpassed, 'D_d', 'G2.d', strresult)
         altobject = 0
      endif
      write (*,110) ' '
      call Inherit_G2_deleteRef_f(object)

      call Inherit_I__create_f(object)
      write (*,110) ' '
      write (*,110) 'Class I:'
      write (*,110) ' '
      call Inherit_I_a_f(object,strresult)
      call reporttest(partno, numpassed, 'I_a', 'I.a', strresult)
      write (*,110) ' '
      write (*,110) ' '
      call Inherit_I_h_f(object,strresult)
      call reporttest(partno, numpassed, 'I_h', 'I.h', strresult)

      write (*,110) ' '
      write (*,110) 'Class I: via class H'
      write (*,110) ' '
      call Inherit_H__cast_f(object, altobject)
      call castcheck(partno, numpassed, 'Class I',
     $     'Class H', altobject)
      if (altobject .ne. 0) then
         call Inherit_H_a_f(altobject,strresult)
         call reporttest(partno, numpassed, 'H_a', 'I.a', strresult)
         write (*,110) ' '
         write (*,110) ' '
         call Inherit_H_h_f(altobject,strresult)
         call reporttest(partno, numpassed, 'H_h', 'I.h', strresult)
         altobject = 0
      endif

      call Inherit_I_deleteRef_f(object)

      if (partno .eq. numpassed) then
         write (*, 110) 'TEST_RESULT PASS'
      else
         write (*, 110) 'TEST_RESULT FAIL'
      endif

 110  format (a)
      end 
