/*
 * File:          sort_CompInt_Impl.c
 * Symbol:        sort.CompInt-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.CompInt
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.CompInt" (version 0.1)
 * 
 * Compare two Integer's.  By default, this will sort in increasing order.
 */

#include "sort_CompInt_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.CompInt._includes) */
#include <stdlib.h>
#include "sort_Integer.h"
/* DO-NOT-DELETE splicer.end(sort.CompInt._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_CompInt__ctor"

void
impl_sort_CompInt__ctor(
  sort_CompInt self)
{
  /* DO-NOT-DELETE splicer.begin(sort.CompInt._ctor) */
  struct sort_CompInt__data *dptr =
    malloc(sizeof(struct sort_CompInt__data));
  if (dptr) {
    dptr->d_increasing = TRUE;
  }
  sort_CompInt__set_data(self, dptr);
  /* DO-NOT-DELETE splicer.end(sort.CompInt._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_CompInt__dtor"

void
impl_sort_CompInt__dtor(
  sort_CompInt self)
{
  /* DO-NOT-DELETE splicer.begin(sort.CompInt._dtor) */
  struct sort_CompInt__data *dptr = 
    sort_CompInt__get_data(self);
  if (dptr) {
    free((void*)dptr);
    sort_CompInt__set_data(self, NULL);
  }
  /* DO-NOT-DELETE splicer.end(sort.CompInt._dtor) */
}

/*
 * If increasing is true, this will cause the comparator to
 * report a normal definition of less than; otherwise, it will
 * reverse the normal ordering.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_CompInt_setSortIncreasing"

void
impl_sort_CompInt_setSortIncreasing(
  sort_CompInt self, SIDL_bool increasing)
{
  /* DO-NOT-DELETE splicer.begin(sort.CompInt.setSortIncreasing) */
  struct sort_CompInt__data *dptr = 
    sort_CompInt__get_data(self);
  if (dptr) {
    dptr->d_increasing = increasing;
  }
  /* DO-NOT-DELETE splicer.end(sort.CompInt.setSortIncreasing) */
}

/*
 * This method is used to define an ordering of objects.  This method
 * will return -1 if i1 < i2, 0 if i1 = i2; and 1 if i1 > i2.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_CompInt_compare"

int32_t
impl_sort_CompInt_compare(
  sort_CompInt self, SIDL_BaseInterface i1, SIDL_BaseInterface i2)
{
  /* DO-NOT-DELETE splicer.begin(sort.CompInt.compare) */
  int result = 0;
  struct sort_CompInt__data *dptr = 
    sort_CompInt__get_data(self);
  if (dptr) {
    sort_Integer int1 = sort_Integer__cast(i1);
    sort_Integer int2 = sort_Integer__cast(i2);
    if (int1 && int2) {
      const int32_t val1 = sort_Integer_getValue(int1);
      const int32_t val2 = sort_Integer_getValue(int2);
      if (val1 < val2) result = -1;
      if (val1 > val2) result = 1;
      if (!dptr->d_increasing) {
        result = -result;
      }
    }
  }
  return result;
  /* DO-NOT-DELETE splicer.end(sort.CompInt.compare) */
}
