/*
 * File:          sort_SortingAlgorithm_Impl.c
 * Symbol:        sort.SortingAlgorithm-v0.1
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for sort.SortingAlgorithm
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sort.SortingAlgorithm" (version 0.1)
 * 
 * An abstract sorting algorithm.
 */

#include "sort_SortingAlgorithm_Impl.h"

/* DO-NOT-DELETE splicer.begin(sort.SortingAlgorithm._includes) */
#include <stdlib.h>
#include "sort_SimpleCounter.h"
/* DO-NOT-DELETE splicer.end(sort.SortingAlgorithm._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortingAlgorithm__ctor"

void
impl_sort_SortingAlgorithm__ctor(
  sort_SortingAlgorithm self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortingAlgorithm._ctor) */
  struct sort_SortingAlgorithm__data *dptr = 
    malloc(sizeof(struct sort_SortingAlgorithm__data ));
  if (dptr) {
    dptr->d_swp = sort_Counter__cast(sort_SimpleCounter__create());
    dptr->d_cmp = sort_Counter__cast(sort_SimpleCounter__create());
  }
  sort_SortingAlgorithm__set_data(self, dptr);
  /* DO-NOT-DELETE splicer.end(sort.SortingAlgorithm._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortingAlgorithm__dtor"

void
impl_sort_SortingAlgorithm__dtor(
  sort_SortingAlgorithm self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortingAlgorithm._dtor) */
  struct sort_SortingAlgorithm__data *dptr = 
    sort_SortingAlgorithm__get_data(self);
  if (dptr) {
    sort_Counter_deleteRef(dptr->d_swp);
    dptr->d_swp = NULL;
    sort_Counter_deleteRef(dptr->d_cmp);
    dptr->d_cmp = NULL;
    free((void *)dptr);
  }
  /* DO-NOT-DELETE splicer.end(sort.SortingAlgorithm._dtor) */
}

/*
 * Return the comparison counter.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortingAlgorithm_getCompareCounter"

sort_Counter
impl_sort_SortingAlgorithm_getCompareCounter(
  sort_SortingAlgorithm self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortingAlgorithm.getCompareCounter) */
  struct sort_SortingAlgorithm__data *dptr = 
    sort_SortingAlgorithm__get_data(self);
  sort_Counter result = NULL;
  if (dptr) {
    sort_Counter_addRef(dptr->d_cmp);
    result = dptr->d_cmp;
  }
  return result;
  /* DO-NOT-DELETE splicer.end(sort.SortingAlgorithm.getCompareCounter) */
}

/*
 * Return the swap counter.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortingAlgorithm_getSwapCounter"

sort_Counter
impl_sort_SortingAlgorithm_getSwapCounter(
  sort_SortingAlgorithm self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortingAlgorithm.getSwapCounter) */
  struct sort_SortingAlgorithm__data *dptr = 
    sort_SortingAlgorithm__get_data(self);
  sort_Counter result = NULL;
  if (dptr) {
    sort_Counter_addRef(dptr->d_swp);
    result = dptr->d_swp;
  }
  return result;
  /* DO-NOT-DELETE splicer.end(sort.SortingAlgorithm.getSwapCounter) */
}

/*
 * Reset the comparison and swap counter.
 */

#undef __FUNC__
#define __FUNC__ "impl_sort_SortingAlgorithm_reset"

void
impl_sort_SortingAlgorithm_reset(
  sort_SortingAlgorithm self)
{
  /* DO-NOT-DELETE splicer.begin(sort.SortingAlgorithm.reset) */
  struct sort_SortingAlgorithm__data *dptr = 
    sort_SortingAlgorithm__get_data(self);
  if (dptr) {
    sort_Counter_reset(dptr->d_swp);
    sort_Counter_reset(dptr->d_cmp);
  }
  /* DO-NOT-DELETE splicer.end(sort.SortingAlgorithm.reset) */
}
