! 
! File:          sort_HeapSort_Impl.F90
! Symbol:        sort.HeapSort-v0.1
! Symbol Type:   class
! Babel Version: 0.8.8
! Description:   Server-side implementation for sort.HeapSort
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.8.8
! 


! 
! Symbol "sort.HeapSort" (version 0.1)
! 
! Heap sort
! 


#include "sort_Counter_fAbbrev.h"
#include "sort_SortingAlgorithm_fAbbrev.h"
#include "sort_HeapSort_fAbbrev.h"
#include "SIDL_BaseInterface_fAbbrev.h"
#include "SIDL_BaseClass_fAbbrev.h"
#include "sort_Comparator_fAbbrev.h"
#include "SIDL_ClassInfo_fAbbrev.h"
#include "sort_Container_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
subroutine remakeHeap(elem, comp, cmp, swp, last, first)
  use sort_Counter
  use sort_Comparator
  use sort_Container
  implicit none
  type(sort_Counter_t) cmp, swp
  type(sort_Comparator_t) comp
  type(sort_Container_t) elem
  integer(selected_int_kind(9)) last, first, half, child, result, counter
  integer(selected_int_kind(9)) f
  f = first
  half = (last/2) - 1
  do while (f .le. half) 
     child = f + f + 1
     if ((child + 1) .lt. last) then
        call inc(cmp, counter)
        call compare(elem, child, child+1, comp, result)
        if (result .lt. 0) then
           child = child + 1
        endif
     endif
     call inc(cmp, counter)
     call compare(elem, f, child, comp, result)
     if (result .ge. 0) goto 100
     call inc(swp, counter)
     call swap(elem, f, child)
     f = child
  enddo
100 return
end subroutine remakeHeap
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine sort_HeapSort__ctor_mi(self)
  use sort_HeapSort
  use sort_HeapSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.HeapSort._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.HeapSort._ctor.use)
  implicit none
  type(sort_HeapSort_t) :: self

! DO-NOT-DELETE splicer.begin(sort.HeapSort._ctor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(sort.HeapSort._ctor)
end subroutine sort_HeapSort__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine sort_HeapSort__dtor_mi(self)
  use sort_HeapSort
  use sort_HeapSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.HeapSort._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.HeapSort._dtor.use)
  implicit none
  type(sort_HeapSort_t) :: self

! DO-NOT-DELETE splicer.begin(sort.HeapSort._dtor)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(sort.HeapSort._dtor)
end subroutine sort_HeapSort__dtor_mi


! 
! Sort elements using Heap Sort.
! 

recursive subroutine sort_HeapSort_sort_mi(self, elems, comp)
  use sort_HeapSort
  use sort_Comparator
  use sort_Container
  use sort_HeapSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.HeapSort.sort.use)
  use sort_Counter
  ! DO-NOT-DELETE splicer.end(sort.HeapSort.sort.use)
  implicit none
  type(sort_HeapSort_t) :: self
  type(sort_Container_t) :: elems
  type(sort_Comparator_t) :: comp

! DO-NOT-DELETE splicer.begin(sort.HeapSort.sort)
  integer(selected_int_kind(9)) i, num, counter
  type(sort_Counter_t) cmp, swp
  call getLength(elems, num)
  call getCompareCounter(self, cmp)
  call getSwapCounter(self, swp)
!     make the heap
  do i = ((num / 2) - 1), 0, -1
     call remakeHeap(elems, comp, cmp, swp, num, i)
  enddo
!     put top of heap at back and remake the heap
  i = num - 1
  do while (i .gt. 0)
     call inc(swp, counter)
     call swap(elems, 0, i)
     call remakeHeap(elems, comp, cmp, swp, i, 0)
     i = i - 1
  enddo
  call deleteRef(cmp)
  call deleteRef(swp)
! DO-NOT-DELETE splicer.end(sort.HeapSort.sort)
end subroutine sort_HeapSort_sort_mi


! 
! Return heap sort.
! 

recursive subroutine sort_HeapSort_getName_mi(self, retval)
  use sort_HeapSort
  use sort_HeapSort_impl
  ! DO-NOT-DELETE splicer.begin(sort.HeapSort.getName.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(sort.HeapSort.getName.use)
  implicit none
  type(sort_HeapSort_t) :: self
  character (len=*) :: retval

! DO-NOT-DELETE splicer.begin(sort.HeapSort.getName)
  retval = 'Heap sort'
! DO-NOT-DELETE splicer.end(sort.HeapSort.getName)
end subroutine sort_HeapSort_getName_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Insert extra code here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
