!
! File:       argstest.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Release:    $Name: release-0-8-8 $
! Revision:   @(#) $Revision: 1.6 $
! Date:       $Date: 2003/02/05 17:28:37 $
! Description:Exercise the FORTRAN interface
!

#include "Strings_Cstring_fAbbrev.h"

subroutine starttest(number)
  implicit none
  integer (selected_int_kind(9)) :: number
  write (6, 100) number
100 format ('PART ', I4)
end subroutine starttest

subroutine reporttest(test, number, pass, fail)
  implicit none
  integer (selected_int_kind(9)) :: number, pass, fail
  logical                        :: test
  if (test) then
     write (6, 100) number, 'PASS'
     pass = pass + 1
  else
     write (6, 100) number, 'FAIL'
     fail = fail + 1
  endif
100 format ('RESULT', 1x, i2, 1x, A4)
  number = number + 1
end subroutine reporttest

subroutine teststring(test, pass, fail)
  use Strings_Cstring
  implicit none
  type(Strings_Cstring_t)         :: obj
  integer (selected_int_kind(9))  :: test, pass, fail
  logical                         :: retval
  character (len=80)              :: in, inout, out, sreturn
  character (len=1)               :: ch1, ch2
  call new(obj)
  sreturn = 'Not three'
  call starttest(test)
  call returnback(obj, .true., sreturn)
  call reporttest(sreturn .eq. 'Three', test, pass, fail)
  retval = .false.
  call starttest(test)
  call passin(obj, 'Three', retval)
  call reporttest(retval, test, pass, fail)
  in = 'Three'
  call starttest(test)
  call passin(obj, in, retval)
  call reporttest(retval, test, pass, fail)
  call starttest(test)
  call passin(obj, 'Four', retval)
  call reporttest(.not. retval, test, pass, fail)
  out = 'Not three'
  call starttest(test)
  call passout(obj, .true., out, retval)
  call reporttest(retval .and. out .eq. 'Three', test, pass, fail)
  inout = 'Three'
  call starttest(test)
  call passinout(obj, inout, retval)
  call reporttest(retval .and. inout .eq. 'threes', test, pass, fail)
  call starttest(test)
  call passeverywhere(obj, 'Three', out, inout, sreturn)
  call reporttest(sreturn .eq. 'Three' .and. out .eq. 'Three' .and. &
       inout .eq. 'Three', test, pass, fail)
  call starttest(test)
  call mixedarguments(obj, 'Test', 'z', 'Test', 'z', retval)
  call reporttest(retval, test, pass, fail)
  call starttest(test)
  call mixedarguments(obj, 'Not', 'A', 'Equal', 'a', retval)
  call reporttest(.not. retval, test, pass, fail)
  ch1 = 'z'
  ch2 = 'z'
  call starttest(test)
  call mixedarguments(obj, 'Test', ch1, 'Test', ch1, retval)
  call reporttest(retval, test, pass, fail)
  call starttest(test)
  call mixedarguments(obj, 'Test', ch1, 'Test', ch2, retval)
  call reporttest(retval, test, pass, fail)
  ch2 = 'A'
  call starttest(test)
  call mixedarguments(obj, 'Not', ch1, 'Equal', ch2, retval)
  call reporttest(.not. retval, test, pass, fail)
  call deleteRef(obj)

end subroutine teststring

program stringstest
  integer (selected_int_kind(9)) :: test, pass, fail
  test = 1
  pass = 0
  fail = 0
  write(6,120) 12
  write(6,110) 'String tests'
  call teststring(test, pass, fail)
  if ((fail .eq. 0) .and. (pass .eq. 12)) then
     write(6, 100) 'PASS'
  else
     write(6, 100) 'FAIL'
  endif
100 format ('TEST_RESULT', 1x, a4)
110 format ('COMMENT:', 1x, a20)
120 format ('NPARTS', 1x, i4)
end program stringstest
