/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.bridge;

import org.apache.batik.util.ParsedURL;

/**
 * This implementation of <tt>ExternalResourceSecurity</tt> allows any 
 * external references.
 *
 * @author <a href="mailto:vhardy@apache.org">Vincent Hardy</a>
 * @version $Id: RelaxedExternalResourceSecurity.java,v 1.2 2002/06/17 13:01:44 vhardy Exp $
 */
public class RelaxedExternalResourceSecurity implements ExternalResourceSecurity {
     /**
     * Controls whether the externalResource should be loaded or not.
     *
     * @throws SecurityException if the externalResource should not be loaded.
     */
    public void checkLoadExternalResource(){
    }

    /**
     * @param externalResourceURL url for the externalResource, as defined in
     *        the externalResource's xlink:href attribute. If that
     *        attribute was empty, then this parameter should
     *        be null
     * @param docURL url for the document into which the 
     *        externalResource was found.
     */
    public RelaxedExternalResourceSecurity(ParsedURL externalResourceURL,
                                           ParsedURL docURL){
        /* do nothing */
    }
}


    
