/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.dom;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

/**
 * This class represents an object which provides the computed styles
 * of the elements of a SVG document.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: CSSOMSVGViewCSS.java,v 1.2 2003/04/11 13:55:19 vhardy Exp $
 */
public class CSSOMSVGViewCSS extends CSSOMViewCSS {
    
    /**
     * Creates a new ViewCSS.
     */
    public CSSOMSVGViewCSS(CSSEngine engine) {
        super(engine);
    }

    /**
     * <b>DOM</b>: Implements {@link
     * org.w3c.dom.css.ViewCSS#getComputedStyle(Element,String)}.
     */
    public CSSStyleDeclaration getComputedStyle(Element elt,
                                                String pseudoElt) {
        if (elt instanceof CSSStylableElement) {
            return new CSSOMSVGComputedStyle(cssEngine,
                                             (CSSStylableElement)elt,
                                             pseudoElt);
        }
        return null;
    }
}
