/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.util.CSSConstants;

/**
 * This class provides a manager for the 'writing-mode' property values.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: WritingModeManager.java,v 1.2 2003/04/11 13:55:58 vhardy Exp $
 */
public class WritingModeManager extends IdentifierManager {
    
    /**
     * The identifier values.
     */
    protected final static StringMap values = new StringMap();
    static {
	values.put(CSSConstants.CSS_LR_VALUE,
                   SVGValueConstants.LR_VALUE);
	values.put(CSSConstants.CSS_LR_TB_VALUE,
                   SVGValueConstants.LR_TB_VALUE);
	values.put(CSSConstants.CSS_RL_VALUE,
                   SVGValueConstants.RL_VALUE);
	values.put(CSSConstants.CSS_RL_TB_VALUE,
                   SVGValueConstants.RL_TB_VALUE);
	values.put(CSSConstants.CSS_TB_VALUE,
                   SVGValueConstants.TB_VALUE);
	values.put(CSSConstants.CSS_TB_RL_VALUE,
                   SVGValueConstants.TB_RL_VALUE);
    }

    /**
     * Implements {@link
     * org.apache.batik.css.engine.value.ValueManager#isInheritedProperty()}.
     */
    public boolean isInheritedProperty() {
	return true;
    }

    /**
     * Implements {@link
     * org.apache.batik.css.engine.value.ValueManager#getPropertyName()}.
     */
    public String getPropertyName() {
	return CSSConstants.CSS_WRITING_MODE_PROPERTY;
    }
    
    /**
     * Implements {@link
     * org.apache.batik.css.engine.value.ValueManager#getDefaultValue()}.
     */
    public Value getDefaultValue() {
        return SVGValueConstants.LR_TB_VALUE;
    }

    /**
     * Implements {@link IdentifierManager#getIdentifiers()}.
     */
    protected StringMap getIdentifiers() {
        return values;
    }
}
