/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.dom.util;

import org.w3c.dom.css.CSSStyleDeclaration;

/**
 * This interface represents CSSStyleDeclaration factories.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: CSSStyleDeclarationFactory.java,v 1.1.1.1 2000/10/10 18:39:28 hillion Exp $
 */
public interface CSSStyleDeclarationFactory {
    /**
     * Creates a stylesheet declaration.
     */
    CSSStyleDeclaration createCSSStyleDeclaration();
}
