#!/bin/csh
#	model.run <file.pros>      <file.pros> = seqs in fasta format
#	Fix Gibbs9_95 model based on min seq len
#	   Expects MINIMUM indicated in input file title line.
#          Always specify blocks 8 wide, Gibbs will "column sampling",
#	   possibly resulting in wider blocks.
#
#	< 36 	1 motif
#	36-85	2 motifs
#	86-135	3
#	136-185	4
#	186-235	5
#	236-285	6
#		etc. to max of 26 motifs allowed by Gibbs program
#
set minlen = (`grep " MINIMUM" $1 |  awk '{print $2}'`)
#echo $minlen
@ l = $minlen
#echo $l
if ($l < 36) then
   set model = 8
else
         set model = "8,8"
	 @ n = 2
         @ x = $l
         @ x -= 35
         @ x -= 50
         while ($n < 26 && $x > 0)
            set model = "$model,8" 
#           echo $x $model
            @ x -= 50
	    @ n += 1
         end
endif
echo $model
exit(0)

