/*
 * $Header: /home/cvs/jakarta-commons/httpclient/src/java/org/apache/commons/httpclient/NTCredentials.java,v 1.6.2.2 2004/02/22 18:21:13 olegk Exp $
 * $Revision: 1.6.2.2 $
 * $Date: 2004/02/22 18:21:13 $
 *
 * ====================================================================
 *
 *  Copyright 2002-2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.commons.httpclient;

/** {@link Credentials} for use with the NTLM authentication scheme which requires additional
 * information.
 *
 * @author <a href="mailto:adrian@ephox.com">Adrian Sutton</a>
 * @author <a href="mailto:mbowler@GargoyleSoftware.com">Mike Bowler</a>
 * 
 * @version $Revision: 1.6.2.2 $ $Date: 2004/02/22 18:21:13 $
 * 
 * @since 2.0
 */
public class NTCredentials extends UsernamePasswordCredentials {

    // ----------------------------------------------------- Instance Variables

    /** The Domain to authenticate with.  */
    private String domain;

    /** The host the authentication request is originating from.  */
    private String host;


    // ----------------------------------------------------------- Constructors

    /**
     * Default constructor.
     */
    public NTCredentials() {
        super();
    }

    /**
     * Constructor.
     * @param userName The user name.  This should not include the domain to authenticate with.
     * For example: "user" is correct whereas "DOMAIN\\user" is not.
     * @param password The password.
     * @param host The host the authentication request is originating from.  Essentially, the
     * computer name for this machine.
     * @param domain The domain to authenticate within.
     */
    public NTCredentials(String userName, String password, String host,
            String domain) {
        super(userName, password);
        this.domain = domain;
        this.host = host;
    }
    // ------------------------------------------------------- Instance Methods


    /**
     * Sets the domain to authenticate with.
     *
     * @param domain the NT domain to authenticate in.
     * 
     * @see #getDomain()
     * 
     */
    public void setDomain(String domain) {
        this.domain = domain;
    }

    /**
     * Retrieves the name to authenticate with.
     *
     * @return String the domain these credentials are intended to authenticate with.
     * 
     * @see #setDomain(String)
     * 
     */
    public String getDomain() {
        return domain;
    }

    /** Sets the host name of the computer originating the request.
     *
     * @param host the Host the user is logged into.
     */
    public void setHost(String host) {
        this.host = host;
    }

    /**
     * Retrieves the host name of the computer originating the request.
     *
     * @return String the host the user is logged into.
     */
    public String getHost() {
        return this.host;
    }
    
    /**
     * Return a string representation of this object.
     * @return A string represenation of this object.
     */
    public String toString() {
        final StringBuffer sbResult = new StringBuffer(super.toString());
        
        sbResult.append(":");
        sbResult.append(this.host == null ? "null" : this.host);
        sbResult.append(this.domain == null ? "null" : this.domain);

        return sbResult.toString();
    }

}
