/****************************************************************************
**
** Copyright (C) 2003-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef TEXTDECODER_H_20030917
#define TEXTDECODER_H_20030917

//----------------------------------------------------------------------------

#include <qdict.h>
#include <qptrvector.h>
#include <qtextcodec.h>
#include <qstring.h>

//----------------------------------------------------------------------------

#include "TextCodec.h"

//----------------------------------------------------------------------------

class CTextDecoderPool
{
public:
   /**
      Creates the decoder pool. After construction the pool is empty.
   */
   CTextDecoderPool(CTextCodecPool *pCodecPool);

   ~CTextDecoderPool();

   /** 
       Creates and adds a decoder for the default codec (ISO8859-1) 
       If the decoder exists already this function does nothing.
       If creation of codec or decoder fails the functions throws an 
       exception.
*/
   void addDefaultDecoder();

   /** 
       Creates and adds a decoder for locale. 
       If the decoder exists already this function does nothing.
       If creation of codec or decoder fails the functions throws an 
       exception.
   */
   void addDecoderForLocale();
   
   /** 
       Creates and adds a decoder for codec of passed name. 
       If the decoder exists already this function does nothing.
       If creation of codec or decoder fails the functions throws an 
       exception.
   */
   void addDecoderForName(const char* name);

   /**
      Returns the decoder accordingly the passed name.
   */
   QTextDecoder *pDecoderForName(const char* name) { return m_decoderDict.find(name); }

   /** Returns the name of codec for locale. */
   QString nameOfCodecForLocale() const;

   /**
      Returns a pointer at the text codec pool.
   */
   CTextCodecPool *pTextCodecPool() { return m_pCodecPool; }
   
   /** Returns a pointer at a vector containing the supported codecs. */
   const QPtrVector<TextCodec::SCodec>* supportedCodecs() const {
      return m_pCodecPool->supportedCodecs();
   }

private:
   CTextCodecPool *m_pCodecPool;
   QDict<QTextDecoder> m_decoderDict;
};

//----------------------------------------------------------------------------

class CMetaTextDecoder
{
public:
   CMetaTextDecoder(CTextCodecPool *pCodecPool);
   ~CMetaTextDecoder();

   /**
      Sets the decoder for all general tasks like cvs update or status.
      If the passed name means the codec-for-locale the function tries to 
      create the decoder. If it fails it creates a decoder for the default
      codec.
   */
   void setGeneralDecoder(const char* name);

   /**
      Decodes the passed data and returns it as Unicode string.
   */
   QString decode(const char *pData, const unsigned int size);

   /**
      Returns a pointer at the text codec pool.
   */
   CTextCodecPool *pTextCodecPool() { return m_pDecoderPool->pTextCodecPool(); }

   /** Returns a pointer at a vector containing the supported codecs. */
   const QPtrVector<TextCodec::SCodec>* supportedCodecs() const {
      return m_pDecoderPool->supportedCodecs();
   }

private:
   CTextDecoderPool *m_pDecoderPool;
   QString m_generalDecoder;
};

//----------------------------------------------------------------------------

#endif //TEXTDECODER_H_20030917

