/****************************************************************************
**
** Copyright (C) 2000-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>,
**                         Wim Delvaux <wim.delvaux@chello.be>,
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

#include <qstrlist.h>
#include <qapplication.h>
#include "loglist.h"

#include "globals.h"

QColor LogListView::SelColor[2];


class QColorGroup;
class QPainter;

LogListView::LogListItem::LogListItem( QListView *list, int _tree,
				       const QString &_file,
				       const QString &_rev,
				       const QString &_branch,
				       const QString &_author,
				       const QString &_comment,
				       const QDateTime &_date  )
  : QListViewItem(list, _file, _rev, _author, _date.toString(LookAndFeel::g_dateTimeFormat), truncateLine(_comment)),
    selection(0),
    tree(_tree),
    file(_file),
    rev(_rev),
    branch(_branch),
    author(_author),
    comment(_comment),
    date(_date)
{
}


QString LogListView::LogListItem::truncateLine(QString s)
{
    int pos;

    if ( (pos = s.find('\n')) != -1 )
        s = s.left(pos) + "...";
    return s;
}

void LogListView::LogListItem::paintCell (QPainter * p, const QColorGroup &cg, 
				 int column, int width, int alignment )
{
	QColorGroup _cg(cg);

        if (isSelected())
	{
		int h, s, v;
		QColor C;
		C = ((LogListView *)listView())->getSelectionColor (selection);
		_cg.setColor (QColorGroup::Highlight, C);
		C.hsv( &h, &s, &v );
		_cg.setColor (QColorGroup::HighlightedText, 
			      (v > 128) ? QColor("black") : QColor("white"));
	}

	QListViewItem::paintCell( p, _cg, column, width, alignment );
}

int LogListView::LogListItem::compare(QListViewItem * item,int col,bool ascending) const {

  if (col == 1) {//revision

    int pos1 = 0;
    int dotPos1 = 0;
    int pos2 = 0;
    int dotPos2 = 0;

    QString txt1 = text(1);
    QString txt2 = item->text(1);

    while (TRUE) {

      dotPos1 = txt1.find(".",pos1);
      dotPos2 = txt2.find(".",pos2);

      if ( (dotPos1 == -1) && (dotPos2 == -1) ) {

	if (txt1.mid(pos1).toInt() > txt2.mid(pos2).toInt()) return 1;
	else if (txt1.mid(pos1).toInt() < txt2.mid(pos2).toInt()) return -1;
	else return 0;

      } else if (dotPos1 == -1) {

	if (txt1.mid(pos1).toInt() > txt2.mid(pos2,dotPos2-pos2).toInt()) return 1;
	else return -1;

      } else if (dotPos2 == -1) {

	if (txt1.mid(pos1,dotPos1-pos1).toInt() < txt2.mid(pos2).toInt()) return -1;
	else return 1;

      }

      int n1 = txt1.mid(pos1,dotPos1-pos1).toInt();
      int n2 = txt2.mid(pos2,dotPos2-pos2).toInt();

      if (n1 > n2) return 1;
      else if (n1 < n2) return -1;

      pos1 = dotPos1+1;
      pos2 = dotPos2+1;
    }

  } else if (col == 3) {//date

    LogListItem * listItem = static_cast<LogListItem *>(item);
    if (date<listItem->date) return -1;
    else if (date>listItem->date) return 1;
    else return 0;

  } else return QListViewItem::compare(item,col,ascending);
}

LogListView::LogListView(QWidget *parent, const char *name)
  : QListView(parent, name), tree(0)
{
	setAllColumnsShowFocus(true);
	setMultiSelection(true);
	setFrameShape (StyledPanel);
	addColumn(tr("File"));
	addColumn(tr("Revision"));
	addColumn(tr("Author"));
	addColumn(tr("Date"));
	addColumn(tr("Log Message"));

	// Set default selection color to black
	for (int i=0; i<2; i++)
		setSelectionColor (i, QColor("black"));

	setSorting (0, false);
}


void LogListView::addRevision(const QString &file,
			      const QString &rev,
			      const QString &branch,
			      const QString &author,
			      const QString &comment,
			      const QDateTime &date)
{
    (void) new LogListItem(this, tree, file, rev, branch, author, comment, date);
}

void LogListView::nextFile() {
  ++tree;
}

void LogListView::setSelectedPair (int treeA, int treeB, QString selectionA, QString selectionB)
{
	bool selected, refresh = false;
	unsigned char selection;
	for (QListViewItemIterator it(this); it.current(); ++it)
	{
	        LogListItem * item = static_cast<LogListItem *>(it.current());

		if ( (treeA == item->tree) && (selectionA == item->rev) )
		{
			selected = true;
			selection = 0;
		}
		else if ( (treeB == item->tree) && (selectionB == item->rev) )
		{
			selected = true;
			selection = 1;
		}
		else
		{
			selected = false;
			selection = 0;
		}

		if ((selected != item->isSelected()) ||
		    (selection != item->selection))
		{
			setSelected (item, selected);
			item->selection = selection;

			// mark for refresh if there are any changes
			refresh = true;
		}
	}

	repaint (refresh);
}


void LogListView::contentsMousePressEvent(QMouseEvent *e) {

  LogListItem *selItem = static_cast<LogListItem*>( itemAt( contentsToViewport(e->pos()) ) );

  if (selItem) {
    setCurrentItem(selItem);
    if ( e->button() == LeftButton ) {
      emit revisionClicked(selItem, FALSE);
    } else if ( (e->button() == MidButton) ||
		(e->button() == RightButton) ) {
      emit revisionClicked(selItem, TRUE);
    }
  }
}


void LogListView::contentsMouseDoubleClickEvent(QMouseEvent *e) {

  LogListItem *selItem = static_cast<LogListItem*>( itemAt( contentsToViewport(e->pos()) ) );
  if (selItem) emit revisionDblClicked(selItem);
}


void LogListView::keyPressEvent(QKeyEvent * e) {
  
  LogListItem *selItem = static_cast<LogListItem*>(currentItem());

  if (selItem && e->key() == Qt::Key_Space) {
    if (e->state() == Qt::ShiftButton) {
      emit revisionClicked(selItem, TRUE);
    } else {
      emit revisionClicked(selItem, FALSE);
    }
  } else QListView::keyPressEvent(e);
}

void LogListView::setSelectionColor (const unsigned char selection, const QColor &color)
{
	SelColor [selection] = color;
}

	
QColor LogListView::getSelectionColor (const unsigned char selection) const
{
	return SelColor [selection];
}

