/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


extern cell *SHAVE_CELL;
extern unsigned char *SHAVE_RASTER;
extern unsigned char *SHAVE_FLAGS;

#define USE_HALL_ALGORITHM

#define WIDTH  SHAVE_CELL->w
#define HEIGHT SHAVE_CELL->h

#define R(x,y)	(SHAVE_RASTER + y * ((SHAVE_CELL->w+7)/8) + x/8)
#define F(x,y)	(SHAVE_FLAGS  + y * ((SHAVE_CELL->w+7)/8) + x/8)

#define IS_PIXEL(x,y)  	((x) >= 0 && (x) < WIDTH &&  \
			 (y) >= 0 && (y) < HEIGHT && \
			 ((*R((x),(y)) & (0x80 >> ((x) % 8))) != 0 || \
			  (*F((x),(y)) & (0x80 >> ((x) % 8))) != 0))

#define SET_PIXEL(x,y)	   (*R(x,y) |= 0x80 >> ((x) % 8))
#define CLEAR_PIXEL(x,y)   (*R(x,y) &= (unsigned char)~(0x80 >> ((x) % 8)))

#define SET_DELETABLE(x,y) (*F(x,y) |= 0x80 >> ((x) % 8))
#define IS_DELETABLE(x,y)  ((x) >= 0 && (x) < WIDTH  && \
			    (y) >= 0 && (y) < HEIGHT && \
			    (*F((x),(y)) & (0x80 >> ((x) % 8))) != 0)

#define CLEAR_DELETABLE(x,y) (*F(x,y) &= (unsigned char)~(0x80 >> ((x) % 8)))
