/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
  
                                                                
       Copyright (C) 1990 Cognitive Technology Corporation.     
  	 All rights reserved. This program is proprietary and     
       a trade secret of Cognitive Technology Corporation.      
                                                                
  
*/

/****************************************************************************
 *                                                                          *
 *                                                                          *
 *                       M A D E B U G                                      *
 *                                                                          *
 *              Tool for memory allocation debugging                        *
 *                                                                          *
 *              Written in 1991 by Yuri Panchul                             *
 *                                                                          *
 *              MADEBUG.H - the header file                                 *
 *                                                                          *
 ***************************************************************************/

# ifndef __MADEBUG_H_INCLUDE
# define __MADEBUG_H_INCLUDE

# include "c_memory.h"
# include "ltconfig.h"
#include   "my_mem.h"

# ifdef MA_DEBUG
/*
#    define malloc(s)     my_malloc  (s,    __FILE__, __LINE__)
#    define realloc(p, s) my_realloc (p, s, __FILE__, __LINE__)
#    define calloc(n, s)  my_calloc  (n, s, __FILE__, __LINE__)
#    define free(p)       my_free    (p,    __FILE__, __LINE__)
*/
void *my_calloc (size_t n, size_t size,   char *pFilename, int nLine);
void my_free (void *ptr,                  char *pFilename, int nLine);
void *my_malloc (size_t size,             char *pFilename, int nLine);
void *my_realloc (void *ptr, size_t size, char *pFilename, int nLine);

# define MAX_HEAP_CHECKINGS  512

void AllocationsAccountingOpen (void);
void AllocationsAccountingClose (void);

extern int MA_DebugLevel;
# endif

void HeapCheck (char *pFilename, int nLine);
void HeapDump (char *pFilename, int nLine, char *pListFilename);

# define HCHECK() (HeapCheck (__FILE__, __LINE__))
# endif
