#!/usr/bin/env python

# Copyright: unknown

# post-file.py

"""
first 3 functinos taken from somone's post here:
http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/146306

Args:
    -h, --help              print this text
    -u url, --url=url       the url the post to
    -f file, --file=file    the file to post

to upload to Ryan's page: 

eg:

post-multipart-urllib2.py \
"--url=http://np-dev/support/np/upload_file_test?form:mode=edit&form:id=upload_file_form&__confirmed_p=0&__refreshing_p=0&formbutton:ok=Save" \
--file=file

"""


import httplib, mimetypes, mimetools, urllib2, cookielib

import getopt, sys, os, urlparse

cj = cookielib.CookieJar()
opener = urllib2.build_opener(urllib2.HTTPCookieProcessor(cj))
urllib2.install_opener(opener)

def post_multipart(host, selector, fields, files):
    """
    Post fields and files to an http host as multipart/form-data.
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return the server's response page.
    """
    content_type, body = encode_multipart_formdata(fields, files)
    headers = {'Content-Type': content_type,
               'Content-Length': str(len(body))}

    url = "http://%s%s" % (host, selector)
    #print "DEBUG: url: " + str(url)
    #print "DEBUG: headers: \n" + str(headers)
    #print "DEBUG: body: \n" + str(body)
    r = urllib2.Request(url, body, headers)

    opened_url = urllib2.urlopen(r)
    url_resonse = opened_url.read()
    # print "DEBUG: " + str(url_resonse)
    return url_resonse

def encode_multipart_formdata(fields, files):
    """
    fields is a sequence of (name, value) elements for regular form fields.
    files is a sequence of (name, filename, value) elements for data to be uploaded as files
    Return (content_type, body) ready for httplib.HTTP instance
    """
    BOUNDARY = mimetools.choose_boundary()
    CRLF = '\r\n'
    L = []
    if (len(fields) > 0):
        #print "DEBUG: field length: " + str(len(fields))
        for (key, value) in fields:
            L.append('--' + BOUNDARY)
            L.append('Content-Disposition: form-data; name="%s"' % key)
            L.append('')
            L.append(value)
    for (key, filename, value) in files:
        L.append('--' + BOUNDARY)
        L.append('Content-Disposition: form-data; name="%s"; filename="%s"' % (key, filename))
        L.append('Content-Type: %s' % get_content_type(filename))
        L.append('')
        L.append(value)
    L.append('--' + BOUNDARY + '--')
    L.append('')
    body = CRLF.join(L)
    content_type = 'multipart/form-data; boundary=%s' % BOUNDARY
    return content_type, body

def get_content_type(filename):
    return mimetypes.guess_type(filename)[0] or 'application/octet-stream'

def usage(msg=''):
    print >> sys.stderr, __doc__
    if msg:
        print >> sys.stderr, msg

def main():

    try:
        optlist, args = getopt.getopt(sys.argv[1:], "hu:f:n:", ["help", "url=", "file=", "file-form-field=" ])
    except getopt.GetoptError:
        # print help information and exit:
        usage("Error in parsing arguments")
        sys.exit(2)

    url = "unknown"
    file_name = None
    # HACK: the field name in Ryan's page - this will need to be supplied for other pages
    # idea: could supply 
    file_form_field = "upload_file"

    for o, a in optlist:
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        if o in ("-u", "--url"):
            url = a
        if o in ("-f", "--file"):
            file_name = a
        if o in ("-n", "--file-form-field"):
            file_form_field = a

    # TODO: make this work for multiple files
    file_obj = file(file_name)
    file_content = file_obj.read()
    file_basename = os.path.basename(file_name)
    files = [ (file_form_field, file_basename, file_content) ]

    url_tuple = urlparse.urlsplit(url)

    args = url_tuple[3]
    fields = []

    for arg in url_tuple[3].split("&"):
        arg_parts = arg.split("=")
        if len(arg_parts) == 2:
            fields.append(arg_parts)
        else:
            if arg != "":
                print "WARNING: arg format needs to be in the format <key>=<value>"
                print "IGNORNING: supplied arg: \"" + str(arg) + "\""
                       
    post_multipart(url_tuple[1], url_tuple[2], fields, files)

if __name__ == "__main__":
    main()

