#!/bin/bash
#
# NAME
# 	multistation-storage-config.sh
#
# AUTHOR
# 	Jason Kim <jason@userful.com>
#
# Description
#   - This program is called whenever system starts.
# 	- Update fdi
# 	- Use userful action method for Mount
#   - Use userful callback function for hotplug
# 	- update gdm pam module to handle storage devices
#
# Called from: multistation-devices-config.sh
#
# Call: multistation-storage-refresh.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

source /etc/sysconfig/xtype

# If the XTYPE is SINGLE, then restore files and exit.
if [ -z "$XTYPE" -o "$XTYPE" == "SINGLE" ]; then

	#
	# resotre hal.conf
	if [ -f /etc/dbus-1/system.d/hal.conf.multi-save ]; then 
		mv -f /etc/dbus-1/system.d/hal.conf.multi-save /etc/dbus-1/system.d/hal.conf
	fi

	#
	# resotre PolicyKit.conf
	if [ -f /etc/PolicyKit/PolicyKit.conf.multi-save ]; then 
        mv -f /etc/PolicyKit/PolicyKit.conf.multi-save /etc/PolicyKit/PolicyKit.conf
    fi

	#
	# resotre 20-storage-methods.fdi
	#if [ -f /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi ]; then # FC6
	#	sed -i -e "s/userful-storage-mount/hal-storage-mount/g" /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi
	#fi

	#
	# remove fdi for the storage device hotplug
	#if [ -f /usr/share/hal/fdi/policy/20thirdparty/99-userful-storage-policy.fdi ]; then #FC6
	#	rm -f /etc/userful/setup/99-userful-storage-policy.fdi 
	#fi

	# Restore gdm pam module
	if [ -e /etc/pam.d/gdm ]; then
		#
		# Restore pam_console for FC
		PAM_MODULE=""
		PAM_MODULE=`grep "pam_console.so" /etc/pam.d/gdm`
		if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
			NEW_PAM_MODULE=${PAM_MODULE:1}
			sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
		fi

		#
		# Restore pam_devperm for SuSE
		PAM_MODULE=""
		PAM_MODULE=`grep "pam_devperm.so" /etc/pam.d/gdm`
		if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" == "#" ]; then
			NEW_PAM_MODULE=${PAM_MODULE:1}
			sed -i -e "s/$PAM_MODULE/$NEW_PAM_MODULE/g" /etc/pam.d/gdm
		fi
	fi

	echo "`date +"%b %d %T"` $ProgramName: Multi X is not enabled." >> $logfile
	exit 0
fi

#
# Update hal.conf
if [ -f /etc/dbus-1/system.d/hal.conf ]; then # FC6, SLED10

	if [ ! -f /etc/dbus-1/system.d/hal.conf.multi-save ]; then

		cp /etc/dbus-1/system.d/hal.conf /etc/dbus-1/system.d/hal.conf.multi-save
        if [[ -x /opt/userful/bin/umx-storage-update-hal-config.py ]]; then
            /opt/userful/bin/umx-storage-update-hal-config.py /etc/dbus-1/system.d/hal.conf
        fi

	fi
fi

# Update PolicyKit.conf if exists.
if [[ -f /etc/PolicyKit/PolicyKit.conf ]]; then

    if [[ ! -f /etc/PolicyKit/PolicyKit.conf.multi-save ]]; then

        cp /etc/PolicyKit/PolicyKit.conf /etc/PolicyKit/PolicyKit.conf.multi-save
        if [[ -x /opt/userful/bin/umx-storage-update-polkit-config.py ]]; then
            /opt/userful/bin/umx-storage-update-polkit-config.py /etc/PolicyKit/PolicyKit.conf
        fi

    fi
fi

#
# Update fdi of the storage methods for Mount, and make soft link.
# If a volume is mounted properly (with proper option), doesn't need to care about Umount and Eject.
#if [ -f /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi ]; then # FC6
#	sed -i -e "s/hal-storage-mount/userful-storage-mount/g" /usr/share/hal/fdi/policy/10osvendor/20-storage-methods.fdi
#fi

#
# Create softlink for Mount function
if [ -f /usr/libexec/hal-storage-mount ]; then # FC6
	ln -sf /opt/userful/bin/userful-storage-mount /usr/libexec/userful-storage-mount
	ln -sf /opt/userful/bin/userful-storage-unmount /usr/libexec/userful-storage-unmount
	ln -sf /opt/userful/bin/userful-storage-eject /usr/libexec/userful-storage-eject

elif [ -f /usr/lib/hal/hal-storage-mount ]; then # Kubuntu 7.04, Debian 4.0
	ln -sf /opt/userful/bin/userful-storage-mount /usr/lib/hal/userful-storage-mount
	ln -sf /opt/userful/bin/userful-storage-unmount /usr/lib/hal/userful-storage-unmount
	ln -sf /opt/userful/bin/userful-storage-eject /usr/lib/hal/userful-storage-eject

elif [ -f /usr/lib/hal/scripts/hal-system-storage-mount ]; then # SLED10
	ln -sf /opt/userful/bin/userful-storage-mount /usr/lib/hal/scripts/userful-storage-mount
	ln -sf /opt/userful/bin/userful-storage-unmount /usr/lib/hal/scripts/userful-storage-unmount
	ln -sf /opt/userful/bin/userful-storage-eject /usr/lib/hal/scripts/userful-storage-eject

fi

#
# add userful fdi for the storage device hotplug
#if [ -d /usr/share/hal/fdi/policy/20thirdparty ]; then #FC6
#	cp -f /etc/userful/setup/99-userful-storage-policy.fdi /usr/share/hal/fdi/policy/20thirdparty
#fi

#
# Create softlink for Hotplug callback function
if [ -d /usr/lib/hal/scripts ]; then #FC6
	ln -sf /opt/userful/bin/multistation-storage-hotplug.sh /usr/lib/hal/scripts/multistation-storage-hotplug.sh
fi

#
# Update gdm pam module
# TODO:
#   What about kdm pam module?
if [ -e /etc/pam.d/gdm ]; then
	# disable pam_console for FC
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_console.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" != "#" ]; then
		sed -i -e "s/$PAM_MODULE/#$PAM_MODULE/g" /etc/pam.d/gdm
	fi

	# disable pam_devperm for SuSE
	PAM_MODULE=""
	PAM_MODULE=`grep "pam_devperm.so" /etc/pam.d/gdm`
	if [ "$PAM_MODULE" != "" -a "${PAM_MODULE:0:1}" != "#" ]; then
		sed -i -e "s/$PAM_MODULE/#$PAM_MODULE/g" /etc/pam.d/gdm
	fi
fi

#
# call multistation-storage-refresh.sh
/opt/userful/bin/multistation-storage-refresh.sh
