#!/bin/bash
#
# dm-config-mx.sh
#
#    Create config file for X. (userful.Mxorg.conf)
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# source lib functions
source /opt/userful/bin/userful-bash-lib.sh

PATH=$PATH:/usr/X11R6/bin/

CPUTYPE=
CARDNAME=
DUALVIEW=0

TOUCHSCREEN=5
DEVTYPE=
VENDORID=
PRODUCTID=
NUM_OF_TOUCH=0

ELOTOUCH=04E7
MITOUCH=0596

OSNAME=
OSVER=
# it is used to be userful.xorg.conf.all
X_CONFIG_FILE="userful.xorg.conf.one"

# find available lspci command.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi
BUSID_LEN=`$LSPCI -n | grep -m 1 "0300: " | cut -d ' ' -f 1 | wc -m`


###
# Check number of DualView capable cards
###
check_dualview()
{
	$LSPCI -n | grep "0300: " > /tmp/videolist.tmp

	while read VIDEOENTRY; do
		if echo $VIDEOENTRY | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
			DEVID=`echo $VIDEOENTRY | awk -- '{print $4}'`
		else
			DEVID=`echo $VIDEOENTRY | awk -- '{print $3}'`
		fi

		if grep "$DEVID" /opt/userful/bin/VGAINFO > /dev/null ; then
			CARDTYPE=`grep "$DEVID" /opt/userful/bin/VGAINFO | awk -- '{print $3}'`
			if [ "$CARDTYPE" == "D" ]; then
				DUALVIEW=$(( $DUALVIEW + 1 ))
			fi
		fi
	done < /tmp/videolist.tmp
}


###
# check if current system is Laptop computer
###
check_laptop()
{
	TMPSTR=`$LSPCI -n | grep -c "0300: "`
	if [ "$TMPSTR" == "1" ]; then  # laptop has only one graphic card entity
		TMPSTR=`$LSPCI -n | grep "0300: "`

		if echo $TMPSTR | tr "[A-Z]" "[a-z]" | grep class > /dev/null 2>&1 ; then
			# has "Class" string in the lspci -n
        	VENDORID=`echo $TMPSTR | awk '{split($4,a,":"); print a[1]}'`
        	VIDEOID=`echo $TMPSTR | awk '{split($4,a,":"); print a[2]}'`
		else
			# doesn't has "Class" string in the lspci -n
        	VENDORID=`echo $TMPSTR | awk '{split($3,a,":"); print a[1]}'`
        	VIDEOID=`echo $TMPSTR | awk '{split($3,a,":"); print a[2]}'`
		fi

		CARDNAME=`grep "0x"$VENDORID /etc/userful/pcitable |
				   grep "0x"$VIDEOID |
				   awk -- '{if(substr($3,2,4) == "Card") {split($0,a,"\""); print a[2]}}' |
				   awk -- '{split($0,b,":"); print b[2]}'`

        # Graphics card for laptop has following strings in it's product name.
		if echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " mobility" > /dev/null 2>&1 || \
		   echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " igp" > /dev/null 2>&1 || \
		   echo $CARDNAME | tr "[A-Z]" "[a-z]" | grep " go" > /dev/null 2>&1 ; then
		   CPUTYPE=`grep -m 1 "model name" /proc/cpuinfo |
				    awk -- '{split($0,a,":"); print a[2]}'`
	   fi
	fi
}

###
# - Check if there is touchscreen device in the system
# - Assumes that any device that has ELOTOUCH and MITOUCH for the Vendor ID 
#   is a Touch screen device
###
function check_touchscreen()
{
	rm -f /tmp/touchscreen-dev
	TOUCH_CNT=0

	## find ELOTOUCH or MITOUCH touch screen.
	while read USBINPUT; do
		if [ "${USBINPUT:0:1}" == "I" ]; then # Interface
			if  echo $USBINPUT | tr "a-z" "A-Z" | grep "VENDOR=$ELOTOUCH" > /dev/null 2>&1 || \
				echo $USBINPUT | tr "a-z" "A-Z" | grep "VENDOR=$MITOUCH" > /dev/null 2>&1; then
				# found Elo touch or Mi touch device
				NUM_OF_TOUCH=$(( $NUM_OF_TOUCH + 1 ))
				TOUCH_CNT=1
			fi
		elif [ "${USBINPUT:0:1}" == "N" -a $TOUCH_CNT -eq 1 ]; then # Name
			if echo $USBINPUT | tr "a-z" "A-Z" | grep "NAME=" > /dev/null 2>&1 ; then
				echo $USBINPUT | awk -F'=' -- '{print $2}' | tr -d "\"" >> /tmp/touchscreen-dev
				TOUCH_CNT=0
			fi
		fi
	done < /proc/bus/input/devices

	## find other touchscreens listed in /opt/userful/bin/USBINPUTTABLE
	while read USBDEV; do
		if ! echo $USBDEV | grep "^[[:space:]]*#" > /dev/null 2>&1 && \
			[ ${#USBDEV} -ne 0 ]; then
			VENDORID=`echo $USBDEV | awk -- '{print $1}'`
			PRODUCTID=`echo $USBDEV | awk -- '{print $2}'`
			DEVTYPE=`echo $USBDEV | awk -- '{print $3}'`

			if [ $DEVTYPE -eq $TOUCHSCREEN ] &&
				[ "$VENDORID" != "$ELOTOUCH" -a "$VENDORID" != "$MITOUCH" ]; then

				# number of current touchscreen device
				CNT=`grep -i "Vendor=$VENDORID Product=$PRODUCTID" /proc/bus/input/devices | wc -l`

				if [ $CNT -gt 0 ]; then
					# get the name of current touchscreen
					grep -i -A 1 "Vendor=$VENDORID Product=$PRODUCTID" /proc/bus/input/devices | \
							grep "N:" | awk -F'"' -- '{print $2}' >> /tmp/touchscreen-dev

					NUM_OF_TOUCH=$(( $NUM_OF_TOUCH + $CNT ))
				fi

			fi
		fi
	done < /opt/userful/bin/USBINPUTTABLE

    if [ -e /tmp/touchscreen-dev ]; then
	    cat /tmp/touchscreen-dev >>  $logfile
    fi
}

#===  FUNCTION  ================================================================
#          NAME:  configure_mx()
#   DESCRIPTION:  Generate X/MX config file. (userful.Mxorg.conf, userful.xorg.conf.one
#                 userful.xorg.conf.all
#    PARAMETERS:  -f (First installation), -n(No config file), -r (reconfiguration)
#       RETURNS:  None
#===============================================================================
function configure_mx()
{
	source /etc/userful/os-info
    # TODO:
    #  - There must be a better way to set the version of Multi-X

	# use new Multi-X for FC6
    if [ -f /opt/MX11R7/bin/Xorg ]; then
	    if [ "$OSNAME" == "fedora" -a "$OSVER" == "2" -o \
		    "$OSNAME" == "fedora" -a "$OSVER" == "3" -o \
		    "$OSNAME" == "fedora" -a "$OSVER" == "4" -o \
		    "$OSNAME" == "novell" -a "$OSVER" == "9" -o \
		    "$OSNAME" == "suse" -a "$OSVER" == "9.1" -o \
		    "$OSNAME" == "suse" -a "$OSVER" == "9.3" -o \
		    "$OSNAME" == "centos" -a "$OSVER" == "4" -o \
		    "$OSNAME" == "freedows" -a "$OSVER" == "2005" -o \
		    "$OSNAME" == "ubuntu" -a "$OSVER" == "5.04" -o \
		    "$OSNAME" == "ubuntu" -a "$OSVER" == "5.10" -o \
		    "$OSNAME" == "xandros" -a "$OSVER" == "3.0" -o \
		    "$OSNAME" == "xandros" -a "$OSVER" == "4.0" -o \
		    "$OSNAME" == "morphix" -a "$OSVER" == "0.5-pre5" -o \
		    "$OSNAME" == "freespire" -a "$OSVER" == "1.0.4" -o \
		    "$OSNAME" == "debian" -a "$OSVER" == "3.1" ]; then
            # Use Old Multi-X for older distors
		    echo "MXVER=MX11R6" > /etc/userful/MXVERSION
            MXVER=MX11R6
            X_CONFIGURE="single"

        elif [ "$OSNAME" == "novell" ] || [ "$OSNAME" == "suse" ]; then
            # Use normal X server to generate xorg.conf.new
		    echo "MXVER=MX11R7" > /etc/userful/MXVERSION
            MXVER=MX11R7
            X_CONFIGURE="single"

	    else
		    echo "MXVER=MX11R7" > /etc/userful/MXVERSION
            MXVER=MX11R7
            X_CONFIGURE="multi"
	    fi
    else
		echo "MXVER=MX11R6" > /etc/userful/MXVERSION
        MXVER=MX11R6
    fi

	if [ -x /usr/X11R6/bin/XFree86 ]; then
		XSERVER="/usr/X11R6/bin/XFree86"
	elif [ -x /usr/X11R6/bin/Xorg ]; then
		XSERVER="/usr/X11R6/bin/Xorg"
	elif [ -x /usr/bin/Xorg ]; then # For X 7.0
		XSERVER="/usr/bin/Xorg"
	else
		echo "`date +"%b %d %T"` $ProgramName: Can't find X server" >> $logfile
		pkill umx-start
		chvt 2
		exit 1
	fi
	
	# configure mga driver
	#/opt/userful/bin/dm-config-mga-driver.sh single

	# initialize
	rm -f /etc/dm-sys-info
	rm -f /tmp/ret-config-message

    #
	# check if the nVidia driver and kernel module exist.
    #
	if $LSPCI -n | tr "a-z" "A-Z" | grep "0300:[[:space:]]10DE:" > /dev/null 2>&1 ; then
	    IS_NVIDIA_DRIVER=$(Check_nVidia_Driver)
        if [[ "$IS_NVIDIA_DRIVER" == "false" ]]; then
	        echo "`date +"%b %d %T"` $ProgramName: nVidia driver and/or kernel module was not found." >> $logfile
        else
	        echo "`date +"%b %d %T"` $ProgramName: Both nVidia card and nVidia driver/kernel module found." >> $logfile
        fi
    fi

    #
	# create xorg.conf.new
    #
    XORG_CONF_NEW=xorg.conf.new
	echo "`date +"%b %d %T"` $ProgramName: Run \"X -configure\" to create $XORG_CONF_NEW " >> $logfile
	rm -f /root/$XORG_CONF_NEW /$XORG_CONF_NEW  2> /dev/null

    #
	# If the system has savage colorgraphics card(s), don't run "X -configure"
	# because X has problem(freezing) with multiple SAVAGE colorgraphics cards (5333:8A22)
	if $LSPCI -n | tr "a-z" "A-Z" | grep "5333:8A22" > /dev/null 2>&1 ; then
		:
	else
        # Generate xorg.conf.new with Multi X on new Linux distros. 
        if [ "$X_CONFIGURE" == "multi" ]; then
            /opt/$MXVER/bin/Xorg -configure -logfile /var/log/mx11r7-configure.log
        else
		    $XSERVER -configure > /dev/null 2>&1
        fi

        #retval=$?
        #if [[ "$retval" != "0" ]]; then
		#	echo "`date +"%b %d %T"` $ProgramName: Multi-X -configure failed." >> $logfile
        #fi

		if [[ ! -f /root/$XORG_CONF_NEW ]]; then
			if [[ -f /$XORG_CONF_NEW ]]; then
				cp -f /$XORG_CONF_NEW /root/
			else
                if [ "$X_CONFIGURE" == "multi" ]; then
                    # If Multi X failed to create xorg.conf.new, use Normal X
		            $XSERVER -configure > /dev/null 2>&1
                else
                    /opt/$MXVER/bin/Xorg -configure -logfile /var/log/mx11r7-configure.log
                fi

                if [[ ! -e /root/$XORG_CONF_NEW ]]; then
			        if [[ -f /$XORG_CONF_NEW ]]; then
				        cp -f /$XORG_CONF_NEW /root/
                    else
                        echo "`date +"%b %d %T"` $ProgramName: /root/$XORG_CONF_NEW is not available." >> $logfile
                    fi
                fi
			fi
		fi
	fi

    #
	# create userful.xorg.conf.all and userful.xorg.conf.one
	/opt/userful/bin/dm-gen-xconfig.sh -one
	/opt/userful/bin/dm-gen-xconfig.sh -all
	#if [[ -f /root/$XORG_CONF_NEW ]]; then
	#	/opt/userful/bin/dm-gen-xconfig.sh -one
	#	/opt/userful/bin/dm-gen-xconfig.sh -all
	#else
	#	/opt/userful/bin/mx-config-gen.sh -all
	#	/opt/userful/bin/mx-config-gen.sh -one
	#fi

    #
    # Monitor Probing
    if [ -e /tmp/Monitor.Probed ]; then
        rm -f /tmp/Monitor.Probed
    fi
    # umx-probe-monitor will create /tmp/Monitor.Probed file if it succeeds.
    /opt/userful/bin/umx-probe-monitor.pl

    # Find resolution
    if [ -e /tmp/Monitor.Probed ]; then
        PROBED_RES=`grep -m1 "ModeLine" /tmp/Monitor.Probed | awk '{print $2}'`
        if [ -z $PROBED_RES ]; then
            PROBED_RES="none"
        fi
    fi

    #
	# create /tmp/sysinfo.tmp for the CPU and VGA information
	/opt/userful/bin/dm-create-sysinfo.sh

    #
	# check if current system is Laptop computer
	check_laptop

	# check if there is TouchScreen device in the system.
	# TouchScreen doesn't support DualView
	check_touchscreen
	#echo "Number of touchscreen: $NUM_OF_TOUCH"
	
    #
	# check reseller's logo
	rm -f /opt/userful/images/reseller-logo.jpg

    if [ -x /opt/userful/bin/dm-gen-info ]; then
        /opt/userful/bin/dm-gen-info -licenseinfo -compare
    else
	    /opt/userful/bin/sno-comp
    fi

	source /etc/userful/userful-license-info
	if [ "$RESELLER_LOGO" != "" -a -e /opt/userful/images/reseller/$RESELLER_LOGO.jpg ]; then
		echo "`date +"%b %d %T"` $ProgramName: Use reseller log: $RESELLER_LOGO.jpg" >>  $logfile
		cp -f /opt/userful/images/reseller/$RESELLER_LOGO.jpg /opt/userful/images/reseller-logo.jpg
	fi

	# Set the X_CONFIG_FILE to userful.xorg.conf.one for some distros that use Xorg 6.9/7.0.
	# New X (Xorg 6.9/7.0) has problem with multiple graphic cards.
	if [ -n "$OSNAME" -a -n "$OSVER" ]; then
		if [ "$OSNAME" == "novell" -a "$OSVER" == "10" ] || 
			[ "$OSNAME" == "ubuntu" -a "$OSVER" == "6.06" ]; then # Novell 10, Ubuntu 6.06
			X_CONFIG_FILE="userful.xorg.conf.one"
		fi
	fi

	# We need to set environment variables for language translation.
	# This could be different for each distro.
	# FC4
	[[ -f /etc/profile.d/lang.sh ]] && source /etc/profile.d/lang.sh
	echo "`date +"%b %d %T"` $ProgramName: LANG=$LANG" >> $logfile

    ##
    ## Remove RgbPath from the $X_CONFIG_FILE if the version of normal X is higher than 1.4
    ## Newer X server has problem with RgbPath in the config file
    if [ "$OSNAME" == "ubuntu" -a "$OSVER" == "8.10" ]; then
        sed -i -e "/RgbPath/d" /etc/X11/$X_CONFIG_FILE
    fi

	# check if config-message program starts properly.
	# Multiple Colorgraphics savage cards causes normal X hung.
	#/opt/userful/bin/watch-x-config.sh &

	if [ -n "$CARDNAME" -a -n "$CPUTYPE" ]; then # In case of Laptop 
		if [ $NUM_OF_TOUCH -gt 0 ]; then
			if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" -nonvidia \
					-touchscreen $NUM_OF_TOUCH -- $XSERVER -config $X_CONFIG_FILE
			else
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" \
					-touchscreen $NUM_OF_TOUCH -- $XSERVER -config $X_CONFIG_FILE
			fi
		else
			if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" -nonvidia -monitor $PROBED_RES \
					-- $XSERVER -config $X_CONFIG_FILE
			else
				xinit /opt/userful/bin/config-message $1 -cpu "$CPUTYPE" -vga "$CARDNAME" -monitor $PROBED_RES \
					-- $XSERVER -config $X_CONFIG_FILE
			fi
		fi
	elif [ $NUM_OF_TOUCH -gt 0 ]; then # Normal Desktop with touchscreen
		if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
			xinit /opt/userful/bin/config-message $1 -touchscreen $NUM_OF_TOUCH -nonvidia \
				-- $XSERVER -config $X_CONFIG_FILE
		else
			xinit /opt/userful/bin/config-message $1 -touchscreen $NUM_OF_TOUCH \
				-- $XSERVER -config $X_CONFIG_FILE
		fi
	else # Normal desktop 
		check_dualview
		if [ "$IS_NVIDIA_DRIVER" == "false" ]; then
			xinit /opt/userful/bin/config-message $1 -dualview $DUALVIEW -nonvidia -monitor $PROBED_RES \
				-- $XSERVER -config $X_CONFIG_FILE
		else
			xinit /opt/userful/bin/config-message $1 -dualview $DUALVIEW -monitor $PROBED_RES \
				-- $XSERVER -config $X_CONFIG_FILE
		fi
	fi

	RET=`cat /tmp/ret-config-message`
	if [ "$RET" == "1" ]; then
		# use old config file
		echo "`date +"%b %d %T"` $ProgramName: Use old configuration instead of creating new one." >>  $logfile
		$LSPCI -n | grep "0300: " > /etc/X11/vgainfo
		return 0
    fi
	#elif [ $RET -ne 0 ]; then
		# exit from startup procedure
		#echo "`date +"%b %d %T"` $ProgramName: Failed to configure system." >>  $logfile
		#pkill prefdm_multi
		#chvt 2
		#exit 1
	#fi

	###
	# create userful.Mxorg.conf
	###
	rm -f /etc/stations
	rm -f /etc/X11/stations
	rm -f /etc/X11/userful.Mxorg.conf
	rm -f /etc/usbinput
	rm -f /etc/X11/xdm/Xservers
	rm -f /etc/mvgainfo

    if [ -x /opt/userful/bin/dm-gen-info ]; then
        /opt/userful/bin/dm-gen-info -licenseinfo -compare
    else
	    /opt/userful/bin/sno-comp
    fi
	$LSPCI -n | grep "0300: " > /etc/X11/vgainfo

	# create config files
	/opt/userful/bin/dm-gen-xconfig.sh -check
	/opt/userful/bin/dm-gen-xconfig.sh -1box
	#if [[ -f /root/$XORG_CONF_NEW ]]; then
	#	/opt/userful/bin/dm-gen-xconfig.sh -check
	#	/opt/userful/bin/dm-gen-xconfig.sh -1box
	#else
	#	pushd /opt/userful/bin > /dev/null
	#		/opt/userful/bin/mx-config-gen.sh -check
	#		/opt/userful/bin/mx-config-gen.sh -1box
   	#	popd > /dev/null
	#fi

	# Block this for a while
	# create config file for normal X if there isn't any.
	#if [ -x /usr/X11R6/bin/XFree86 ] && [ ! -e /etc/X11/XF86Config ]; then
	#	cp -f /etc/X11/userful.xorg.conf.one /etc/X11/XF86Config
	#
	#elif [ ! -e /etc/X11/xorg.conf ]; then
	#	cp -f /etc/X11/userful.xorg.conf.one /etc/X11/xorg.conf
	#fi

	# There are Touchscreen device. Need to calibrate
	if [ -e /tmp/touchscreen-dev ]; then
		echo "`date +"%b %d %T"` $ProgramName: Calibration procedure starts." >>  $logfile
		/opt/userful/evtouch/calibrate.sh
	fi

	# reboot system if Matrox Card exists
	#$LSPCI -n | grep "0300: " | tr "a-z" "A-Z" | grep 102B > /dev/null
	#if [ $? -eq 0 ]; then
	#	sync;sync;reboot;reboot
	#fi
}

#-----------------
# Start from here
#-----------------

#################################
# Check if user has root access..
#################################
IsRoot

# Getting license key if there is a OEM file
if [ -e /etc/userful/oem -a ! -e /etc/X11/1Box.info ]; then
	echo
	echo "Getting OEM license key...."

	/usr/share/1box-utils/install-license.sh > /var/log/oem.log 2>&1

	if [ ! -e /etc/X11/1Box.info ]; then
		echo
		echo "Error: Unable to get OEM license key."
		cat /var/log/oem.log
		sleep 3
	else
		echo
		echo "Successfully obtained OEM license key."
		sleep 3
	fi
fi

## Source dm.conf to find VIDEO_CONF
if [ -f /etc/userful/dm.conf ]; then
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
    source /tmp/dm.conf.tmp
fi


if [ "$VIDEO_CONF" == "static" ]; then
    ## Static Configuration
    if [ ! -e /etc/X11/userful.Mxorg.conf ]; then
        if [ -e /etc/userful/DM-install ]; then
            configure_mx -f
        else
            configure_mx -n
        fi
    fi

else
    ## Dynamic Configuration
    if [ ! -e /etc/X11/userful.Mxorg.conf ]; then
        if [ -e /etc/userful/DM-install ]; then
            configure_mx -f
        else
            configure_mx -n
        fi
    else
        if [ ! -e /etc/X11/vgainfo -o  ! -e /etc/stations -o \
               ! -e /etc/X11/stations -o ! -e /etc/mvgainfo ]; then
            configure_mx -n
        else
            $LSPCI -n | grep "0300: " > /etc/X11/vgainfo.new

            diff /etc/X11/vgainfo /etc/X11/vgainfo.new > /dev/null
            if [ $? != 0 ];then
                # there are changes in the graphic cards
                cp -f /etc/X11/userful.Mxorg.conf /etc/X11/userful.Mxorg.conf.old
                configure_mx -r
            fi
        fi
    fi
fi

if [ -x /opt/userful/bin/dm-gen-info ]; then
    /opt/userful/bin/dm-gen-info -compare
else
    /opt/userful/bin/sno-comp
fi

if [ $? != 0 ]; then
	# there is change in the # of station of the key file
	# no need to re-create config file
	rm -f /etc/X11/xdm/Xservers
	rm -f /etc/stations
    if [ -x /opt/userful/bin/dm-gen-info ]; then
        /opt/userful/bin/dm-gen-info -compare
    else
        /opt/userful/bin/sno-comp
    fi
fi

## Generate licese info file
if [ -x /opt/userful/bin/dm-gen-info ]; then
    /opt/userful/bin/dm-gen-info -licenseinfo
fi
