#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# Copyright 2006 (C) Raster Software Vigo (Sergio Costas)

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import sys
import os
import pygtk # for testing GTK version number
pygtk.require ('2.0')
import gtk
import gtk.glade
import gobject
import subprocess
import signal
import select
import time
import re
import locale
import gettext

title_to_delete=""
chapter_to_delete=""
chapter_to_modify=[]
new_chapter=[]
cancel_prog=False
titlecounter=2
currentfileselected=0
currenttitleselected=-2
PAL=True
erase_temporary_files=False
disctocreate=""

pathlist=["/usr/bin","/usr/local/bin","/usr/share/bin","/usr/share/local/bin","/bin"]

def launch_program(program,salida=True):

	global pathlist # we try all the possible paths

	print "Launching program:"
	print program
	print

	for elemento in pathlist:
		if elemento[-1]!="/":
			elemento+="/"
		try:
			program2=program[:]
			program2[0]=elemento+program2[0]
			if salida:
				handle=subprocess.Popen(program2,executable=program[0],shell=False,bufsize=32768,stdout=subprocess.PIPE,stderr=subprocess.PIPE)
			else:
				handle=subprocess.Popen(program2,executable=program[0],shell=False)
		except OSError:
			pass
		else:
			return handle
	return None

def get_marked():

	global ltitles
	global lchapters
	global structure
	global currentfileselected
	global currenttitleselected
	
	try:
		tree,iter=ltitles.get_selection().get_selected()
		titulo=tree.get_value(iter,0)
	except TypeError:
		titulo=-1
		
	try:
		tree,iter=lchapters.get_selection().get_selected()
		capitulo=1+tree.get_value(iter,0) # zero is the Title value
	except TypeError:
		capitulo=-1
	
	currenttitleselected=titulo
	currentfileselected=capitulo
	
	return titulo,capitulo

def set_buttons():
	global del_title
	global add_chapter
	global del_chapter
	global prop_chapter
	global main_go
	global structure
	global title_down
	global title_up
	global files_down
	global files_up

	titulo,capitulo=get_marked()
		
	if titulo==-1:
		title_marked=False
	else:
		title_marked=True

	if titulo==0:
		title_up.set_sensitive(False)
	else:
		title_up.set_sensitive(True)
	
	if titulo+1==len(structure):
		title_down.set_sensitive(False)
	else:
		title_down.set_sensitive(True)

	if capitulo==-1:
		chapter_marked=False
	else:
		chapter_marked=True

	if capitulo<2:
		files_up.set_sensitive(False)
	else:
		files_up.set_sensitive(True)
		
	if (capitulo==-1) or (capitulo+1==len(structure[titulo])):
		files_down.set_sensitive(False)
	else:
		files_down.set_sensitive(True)

	if len(structure)>1:
		del_title.set_sensitive(title_marked)	
	else:
		del_title.set_sensitive(False)
	
	add_chapter.set_sensitive(title_marked)
	del_chapter.set_sensitive(chapter_marked)
	prop_chapter.set_sensitive(chapter_marked)
	
	valor=False
	
	for elemento in structure:
		if len(elemento)>1:
			valor=True
			break
	main_go.set_sensitive(valor)
	set_video_values()

def dvd_changed(args):
	set_video_values()

def calcula_tamano_total():
	
	global structure
	
	total=0.0
	for elemento in structure:
		if len(elemento)>1:
			for encontrado in elemento[1:]:
				l=float(((encontrado[8]+encontrado[9])*encontrado[4])/8)
				if encontrado[19]!=0:
					l/=2
				total+=l
	return total

def set_video_values():

	global structure
	global arbol

	titulo,capitulo=get_marked()

	if (capitulo!=-1) and (titulo!=-1):
		encontrado2=structure[titulo]
		encontrado=encontrado2[capitulo]
		w=arbol.get_widget("o_size")
		w.set_text(str(encontrado[2])+"x"+str(encontrado[3]))
		w=arbol.get_widget("leng")
		w.set_text(str(encontrado[4]))
		w=arbol.get_widget("vrate")
		w.set_text(str(encontrado[8]))
		w=arbol.get_widget("arate")
		w.set_text(str(encontrado[9]))
		w=arbol.get_widget("eleng")
		l=int(((encontrado[8]+encontrado[9])*encontrado[4])/8000)
		w.set_text(str(l))#+(l/50))) # add a 2% for failsafe
		w=arbol.get_widget("achap")
		if encontrado[13]==0:
			w.set_text(_("no chapters"))
		else:
			w.set_text(str(int(encontrado[13])))
		w=arbol.get_widget("video_format")
		if encontrado[15]==25:
			w.set_text("25 (PAL)")
		elif encontrado[15]==30:
			w.set_text("30 (NTSC)")
		else:
			w.set_text(str(int(encontrado[15])))
		
		w=arbol.get_widget("fsizem")
		w.set_text(str(encontrado[10])+"x"+str(encontrado[11]))
	else:
		w=arbol.get_widget("o_size")
		w.set_text("")
		w=arbol.get_widget("leng")
		w.set_text("")
		w=arbol.get_widget("vrate")
		w.set_text("")
		w=arbol.get_widget("arate")
		w.set_text("")
		w=arbol.get_widget("eleng")
		w.set_text("")
		w=arbol.get_widget("achap")
		w.set_text("")
		w=arbol.get_widget("video_format")
		w.set_text("")
		w=arbol.get_widget("fsizem")
		w.set_text("")
		
	total=calcula_tamano_total()
	total/=1000
	
	w=arbol.get_widget("dvdsize")
	activo=w.get_active()
	if 0==activo:
		tamano=180.0
	elif 1==activo:
		tamano=710.0
	elif 2==activo:
		tamano=790.0
	elif 3==activo:
		tamano=1200.0
	elif 4==activo:
		tamano=4500.0
	else:
		tamano=7600.0
	w=arbol.get_widget("usage")
	if total>tamano:
		w.set_fraction(1.0)
		addv=1
	else:
		w.set_fraction(total/tamano)
		addv=0
	w.set_text(str(addv+int((total/tamano)*100))+"%")


def titleup(args):
	
	global structure
	global currenttitleselected
	
	titulo,capitulo=get_marked()
	
	tempo=structure[titulo-1]
	structure[titulo-1]=structure[titulo]
	structure[titulo]=tempo
	currenttitleselected-=1
	refresh_titles()
	refresh_chapters()
	set_buttons()

def titledown(args):

	global structure
	global currenttitleselected
	
	titulo,capitulo=get_marked()
	
	tempo=structure[titulo+1]
	structure[titulo+1]=structure[titulo]
	structure[titulo]=tempo
	currenttitleselected+=1
	refresh_titles()
	refresh_chapters()
	set_buttons()

def filesup(args):

	global structure
	global currentfileselected
	
	titulo,capitulo=get_marked()

	tempo=structure[titulo][capitulo-1]
	structure[titulo][capitulo-1]=structure[titulo][capitulo]
	structure[titulo][capitulo]=tempo
	currentfileselected-=1
	refresh_chapters()
	set_buttons()

def filesdown(args):

	global structure
	global currentfileselected
	
	titulo,capitulo=get_marked()
	
	tempo=structure[titulo][capitulo+1]
	structure[titulo][capitulo+1]=structure[titulo][capitulo]
	structure[titulo][capitulo]=tempo
	currentfileselected+=1
	refresh_chapters()
	set_buttons()

def show_about(args):

	global wabout
	
	wabout.show()

def refresh_titles(args=""):

	global arbol
	global list_titles
	global list_chapters
	global structure
	global currenttitleselected
	global currentfileselected
	
	currentfileselected=-1
	
	list_titles.clear()
	list_chapters.clear()
		
	contador=-1
	for elemento in structure:
		contador+=1
		entrada=list_titles.insert_before(None,None)
		list_titles.set_value(entrada,1,elemento[0])
		list_titles.set_value(entrada,0,contador)
	
	if contador<currenttitleselected:
		currenttitleselected=contador
	
	if currenttitleselected<0:
		currenttitleselected=0

	ltitles.get_selection().select_path( (currenttitleselected,))


def refresh_chapters(args=""):

	global arbol
	global ltitles
	global lchapters
	global structure
	global currenttitleselected
	global currentfileselected
	
	fichero=currentfileselected
	titulo,fichero2=get_marked()
	
	if (titulo==-1):
		return
	
	if (currentfileselected==-1):
		currentfileselected=1
	else:
		currentfileselected=fichero
	
	list_chapters.clear()
	
	lista=structure[titulo]

	if lista==[]:
		return
	if len(lista)==1:
		return
		
	contador=0
	for elemento in lista[1:]:
		entrada=list_chapters.insert_before(None,None)
		list_chapters.set_value(entrada,1,elemento[0])
		list_chapters.set_value(entrada,0,contador)
		contador+=1
	
	if contador<currentfileselected:
		currentfileselected=contador
	
	lchapters.get_selection().select_path( (currentfileselected-1,))
	

def noabort(args):

	global wcancel
	
	wcancel.hide()
	
def siabort(args):

	gtk.main_quit()

def wmain_delete(args,more=""):

	global arbol
	global wcancel
	
	wcancel=arbol.get_widget("wcancel")
	wcancel.show()
	
	return True

def titleclick(args="",more=""):

	global structure
	
	refresh_chapters()
	set_buttons()
	
def chapterclick(args="",more=""):
	set_buttons()

def addtitle(args):

	global structure
	global titlecounter
	
	structure.append([(_("Title"))+str(titlecounter)])
	titlecounter+=1
	refresh_titles()
	set_buttons()

def deltitle(args):

	global title_to_delete
	global wdel_title

	titulo,capitulo=get_marked()
	title_to_delete=titulo
	etiqueta=arbol.get_widget("what_title")
	etiqueta.set_text(structure[titulo][0])
	wdel_title.show()

def delete_title(args):

	global title_to_delete
	global wdel_title
	global structure

	contador=0
	contador2=0
	tempo=[]
	for elemento in structure:
		if contador2!=title_to_delete:
			tempo.append(elemento)
			contador+=1
		contador2+=1
	structure=tempo
	refresh_titles()
	set_buttons()
	refresh_chapters()
	wdel_title.hide()

def no_delete_title(args):

	global title_to_delete
	global wdel_title

	title_to_delete=""
	wdel_title.hide()

def addchapter(args,erase=True):

	global wfile
	global chapter_to_modify
	global arbol
	global new_chapter
	global PAL
	global disctocreate
	
	chapter_to_modify=[]
	new_chapter=[]
	if erase:
		w=arbol.get_widget("moviefile")
		w.set_filename("")
	w=arbol.get_widget("fileaccept")
	w.set_sensitive(False)
	w=arbol.get_widget("preview_film")
	w.set_sensitive(False)
	w=arbol.get_widget("video_rate")
	if disctocreate=="vcd":
		w.set_value(1150)
		w.set_sensitive(False)
	elif (disctocreate=="svcd") or (disctocreate=="cvd"):
		w.set_value(2000)
		w.set_range(500,2375)
	else:
		w.set_value(5000)
	w=arbol.get_widget("audio_rate")
	w.set_value(224)
	if disctocreate=="vcd":
		w.set_sensitive(False)
	w=arbol.get_widget("do_chapters")
	w.set_active(True)
	w=arbol.get_widget("chapter_long")
	w.set_value(5)
	w=arbol.get_widget("audiodelay")
	w.set_value(0.0)
	w=arbol.get_widget("blackbars")
	w.set_active(True)
	w=arbol.get_widget("full_length")
	w.set_active(True)
	if PAL:
		w=arbol.get_widget("video_pal")
	else:
		w=arbol.get_widget("video_ntsc")
	w.set_active(True)
	w=arbol.get_widget("resauto")
	w.set_active(True)
	w=arbol.get_widget("custom_params")
	w.set_text("")
	w=arbol.get_widget("advanced_expander")
	w.set_expanded(False)
	wfile.show()

def chaptercancel(args):

	global wfile
	global arbol
	
	wfile.hide()

def value_changed(args):

	set_final_size()
	refresh_film_data()

def filechanged(args):
	
	global new_chapter
	global arbol
	
	filechoser=arbol.get_widget("moviefile")
	fileaccept=arbol.get_widget("fileaccept")
	preview_film2=arbol.get_widget("preview_film")
		
	filename=filechoser.get_filename()
	if (filename==None) or (filename==""):
		fileaccept.set_sensitive(False)
		preview_film2.set_sensitive(False)
		return


	done,audio=set_values_of_file(filename)
	
	if done:
		refresh_film_data()
		refresh_screen()
		fileaccept.set_sensitive(True)
		preview_film2.set_sensitive(True)
	else:
		if audio==0:
			show_error(_("File doesn't seem to be a video file."))
		else:
			show_error(_("File seems to be an audio file."))
		new_chapter=[]
		fileaccept.set_sensitive(False)
		preview_film2.set_sensitive(False)
		
def set_values_of_file(filename,blind=False):

	global new_chapter
	global arbol
	global disctocreate

	handler=subprocess.Popen('mplayer -identify -ao null -vo null -frames 0 "'+filename+'" 2>/dev/null |grep ID',shell=True,bufsize=32768,stdout=subprocess.PIPE)
	handler.wait()
	vrate=0
	arate=0
	width=0
	heigh=0
	fps=0
	length=0
	audio=0
	video=0
	audiorate=0
	aspect_ratio=1.3333333333
	while True:
		linea=handler.stdout.readline()
		if linea=="":
			break
		if linea[:16]=="ID_VIDEO_BITRATE":
			vrate=int(linea[17:])
		if linea[:14]=="ID_VIDEO_WIDTH":
			width=int(linea[15:])
		if linea[:15]=="ID_VIDEO_HEIGHT":
			heigh=int(linea[16:])
		if linea[:15]=="ID_VIDEO_ASPECT":
			aspect_ratio=float(linea[16:])
		if linea[:12]=="ID_VIDEO_FPS":
			posic=linea.find(".")
			if posic==-1:
				fps=int(linea[13:])
			else:
				fps=int(linea[13:posic])
				if linea[posic+1]=="9":
					fps+=1
		if linea[:16]=="ID_AUDIO_BITRATE":
			arate=int(linea[17:])
			
		if linea[:13]=="ID_AUDIO_RATE":
			audiorate=int(linea[14:])
			
		if linea[:9]=="ID_LENGTH":
			length=int(float(linea[10:]))
		if linea[:11]=="ID_VIDEO_ID":
			video+=1
		if linea[:11]=="ID_AUDIO_ID":
			audio+=1
	
	if video==0:
		return False,audio
	
	while filename[-1]=="/":
		filename=filename[:-1]
	
	nombre=filename
	while True: # get the filename without the path
		posic=nombre.find("/")
		if posic==-1:
			break
		else:
			nombre=nombre[posic+1:]
	# filename[0]; path[1]; width[2]; heigh[3]; length[4] (seconds); original fps[5];
	# original videorate[6]; original audiorate[7];
	# final videorate[8]; final arate[9]; final width[10]; final heigh[11];
	# 0=Black bars, 1=Scale picture [12];
	# length of chapters[13]; audio delay[14]; final fps[15]; original audio rate (uncompressed)[16];
	# original aspect ratio[17]; final aspect ratio[18];
	# 0=full length, 1=first half, 2=second half [19];
	# Resolution: 0=auto, 1=720x480, 2=704x480, 3=480x480, 4=352x480, 5=352x240 [20]
	# extra parameters [21]

	new_chapter=[nombre, filename, width,heigh, length, fps, vrate/1000, arate/1000, 0, 0, 720, 576, 0 , 5 ,0 ,25 ,audiorate,aspect_ratio,1.33333333,0,0,""]
		
	set_final_size(blind)
	
	return True,0
	

def set_final_size(blind=False):

	global arbol
	global new_chapter
	global PAL
	global disctocreate
	
	if blind:
		pal2=PAL
	else:
		w=arbol.get_widget("video_pal")
		pal2=w.get_active()
	
	if pal2:
		PAL=True
		nheigh1=576
		nheigh2=288
	else:
		PAL=False
		nheigh1=480
		nheigh2=240
		
	if len(new_chapter)==0:
		return
	
	retorno,resx,resy=get_resolution_from_buttons()

	new_chapter[20]=retorno
	if retorno!=0: # custom resolution
		new_chapter[10]=resx
		new_chapter[11]=resy

	if PAL:
		new_chapter[15]=25
	else:
		new_chapter[15]=30
	
	w=arbol.get_widget("video_rate")
	valor=w.get_value()
	
	if (blind) or (disctocreate!="dvd"):
		change_datarate=False
	else:
		if (valor==5000) or (valor==2000) or (valor==3000):
			change_datarate=True
		else:
			change_datarate=False
	if disctocreate=="vcd":
		new_chapter[8]=1150
		new_chapter[9]=224
		if retorno==0:
			new_chapter[10]=352
			new_chapter[11]=nheigh2
		return
	elif disctocreate=="cvd":
		if blind:
			new_chapter[8]=2000
			new_chapter[9]=224
		if retorno==0:
			new_chapter[10]=352
			new_chapter[11]=nheigh1
		if change_datarate:
			w.set_value(2000)
		return
	elif disctocreate=="svcd":
		if blind:
			new_chapter[8]=2000
			new_chapter[9]=224
		if retorno==0:
			new_chapter[10]=480
			new_chapter[11]=nheigh1
		if change_datarate:
			w.set_value(2000)
		return
	
	# DVD

	if (new_chapter[2]<=352):
		if (new_chapter[3]<=nheigh2):
			if change_datarate:
				w.set_value(2000)
			if blind:
				new_chapter[8]=2000
				new_chapter[9]=224
			if retorno==0:
				new_chapter[10]=352
				new_chapter[11]=nheigh2
		else:
			if change_datarate:
				w.set_value(3000)
			if blind:
				new_chapter[8]=3000
				new_chapter[9]=224
			if retorno==0:
				new_chapter[10]=352
				new_chapter[11]=nheigh1
	else:
		if change_datarate:
			w.set_value(5000)
		if blind:
			new_chapter[8]=5000
			new_chapter[9]=224
		if retorno==0:
			new_chapter[10]=720
			new_chapter[11]=nheigh1

def refresh_film_data():
	global arbol
	global new_chapter
	
	
	if len(new_chapter)==0:
		empty=True
	else:
		empty=False
	
	w=arbol.get_widget("video_pal")
	set_resolution(w.get_active())
	
	w=arbol.get_widget("o_size2")
	if empty:
		w.set_text("")
	else:
		w.set_text(str(new_chapter[2])+"x"+str(new_chapter[3]))
	w=arbol.get_widget("leng2")
	if empty:
		w.set_text("")
	else:
		w.set_text(str(new_chapter[4]))
	w=arbol.get_widget("fps")
	if empty:
		w.set_text("")
	else:
		w.set_text(str(new_chapter[5]))
	w=arbol.get_widget("vrate2")
	if empty:
		w.set_text("")
	else:
		w.set_text(str(new_chapter[6]))
	w=arbol.get_widget("arate2")
	if empty:
		w.set_text("")
	else:
		w.set_text(str(new_chapter[7]))
	w=arbol.get_widget("video_rate")
	vrate=w.get_value()
	w=arbol.get_widget("audio_rate")
	arate=w.get_value()
	w=arbol.get_widget("full_length")
	if w.get_active():
		divide=False
	else:
		divide=True
	w=arbol.get_widget("eleng2")
	if empty:
		w.set_text("")
	else:
		l=int(((vrate+arate)*new_chapter[4])/8000)
		if divide:
			l/=2
		w.set_text(str(l))
		
	w=arbol.get_widget("f_size2")
	if empty:
		w.set_text("")
	else:
		w.set_text(str(new_chapter[10])+"x"+str(new_chapter[11]))

def show_error(message):

	global arbol
	global werror
	
	label=arbol.get_widget("l_error")
	label.set_text(message)
	werror.show()

def errorok(args):

	global werror
	
	werror.hide()

def global_delete(arg1,arg2):
#just hide that widget

	arg1.hide()
	return True

def set_file_values():

	global arbol
	global new_chapter

	w=arbol.get_widget("blackbars")
	if w.get_active():
		new_chapter[12]=0
	else:
		new_chapter[12]=1
	
	w=arbol.get_widget("do_chapters")
	if w.get_active():
		w=arbol.get_widget("chapter_long")
		new_chapter[13]=w.get_value()
	else:
		new_chapter[13]=0
	
	w=arbol.get_widget("audiodelay")
	new_chapter[14]=float(w.get_value())
		
	w=arbol.get_widget("video_rate")
	new_chapter[8]=int(w.get_value())
	w=arbol.get_widget("audio_rate")
	new_chapter[9]=int(w.get_value())
	
	w=arbol.get_widget("full_length")
	if w.get_active():
		new_chapter[19]=0
	else:
		w=arbol.get_widget("first_half")
		if w.get_active():
			new_chapter[19]=1
		else:
			new_chapter[19]=2

	w=arbol.get_widget("video_pal")
	if w.get_active():
		new_chapter[15]=25
	else:
		new_chapter[15]=30
		
	retorno,resx,resy=get_resolution_from_buttons()
	new_chapter[20]=retorno
	
	w=arbol.get_widget("custom_params")
	new_chapter[21]=w.get_text()

def get_resolution_from_buttons():

	global arbol

	retorno=0
	resx=0
	resy=0

	w=arbol.get_widget("video_pal")
	if w.get_active():
		h1=576
		h2=288
	else:
		h1=480
		h2=240

	w=arbol.get_widget("res720x480")
	if w.get_active():
		retorno=1
		resx=720
		resy=h1
	
	w=arbol.get_widget("res704x480")
	if w.get_active():
		retorno=2
		resx=704
		resy=h1
		
	w=arbol.get_widget("res480x480")
	if w.get_active():
		retorno=3
		resx=480
		resy=h1
		
	w=arbol.get_widget("res352x480")
	if w.get_active():
		retorno=4
		resx=352
		resy=h1
		
	w=arbol.get_widget("res352x240")
	if w.get_active():
		retorno=5
		resx=352
		resy=h2
		
	return retorno,resx,resy
		

def add_a_file(args):

	global arbol
	global new_chapter
	global structure
	global wfile
	global chapter_to_modify
	
	set_file_values()
	
	titulo,capitulo=get_marked()
	
	if len(chapter_to_modify)==0:
		for elemento in structure:
			if elemento[0]==structure[titulo][0]:
				elemento.append(new_chapter)
				break
	else:
		for elemento in range(len(new_chapter)):
			chapter_to_modify[elemento]=new_chapter[elemento]
	
	save_config()
	
	wfile.hide()
	refresh_chapters()
	set_buttons()

def delete_chapter(args):

	global wdel_chapter
	global arbol
	global chapter_to_erase
	
	titulo,capitulo=get_marked()
	label=arbol.get_widget("labelchapter")
	label.set_text(structure[titulo][capitulo][0])
	
	wdel_chapter.show()

def delete_chapter_no(args):

	global wdel_chapter

	wdel_chapter.hide()
	
def delete_chapter_yes(args):

	global arbol
	global structure
	global wdel_chapter
	
	wdel_chapter.hide()
	
	newstruct=[]
	newtitle=[]

	titulo,capitulo=get_marked()

	contador=0
	for elemento in structure:
		if contador!=titulo:
			newstruct.append(elemento)
		else:
			contador2=0
			for elemento2 in elemento:
				if contador2!=capitulo:
					newtitle.append(elemento2)
				contador2+=1
			newstruct.append(newtitle)
		contador+=1
	structure=newstruct
	
	refresh_chapters()
	set_buttons()

def modify_chapter(args):

	global arbol
	global wfile
	global structure
	global chapter_to_modify
	global disctocreate
	
	titulo,capitulo=get_marked()
	
	if (titulo==-1) or (capitulo==-1):
		return

	chapter_to_modify=structure[titulo][capitulo]
	
	if chapter_to_modify[20]==0: # auto resolution
		w=arbol.get_widget("resauto")
	elif chapter_to_modify[20]==1: # 720x480
		w=arbol.get_widget("res720x480")
	elif chapter_to_modify[20]==2: # 704x480
		w=arbol.get_widget("res704x480")
	elif chapter_to_modify[20]==3: # 480x480
		w=arbol.get_widget("res480x480")
	elif chapter_to_modify[20]==4: # 352x480
		w=arbol.get_widget("res352x480")
	else:
		w=arbol.get_widget("res352x240")
	
	w.set_active(True)
	
	if disctocreate=="vcd":
		w=arbol.get_widget("video_rate")
		w.set_value(1150)
		w.set_sensitive(False)
		w=arbol.get_widget("audio_rate")
		w.set_value(224)
		w.set_sensitive(False)
	elif (disctocreate=="svcd") or (disctocreate=="cvd"):
		w=arbol.get_widget("video_rate")
		w.set_range(500,2375)
	
	w=arbol.get_widget("advanced_expander")
	w.set_expanded(False)
	
	w=arbol.get_widget("custom_params")
	w.set_text(chapter_to_modify[21])
	
	fileaccept=arbol.get_widget("fileaccept")
	fileaccept.set_sensitive(True)
	preview_film2=arbol.get_widget("preview_film")
	preview_film2.set_sensitive(True)
	vrate=arbol.get_widget("video_rate")
	vrate.set_value(chapter_to_modify[8])
	arate=arbol.get_widget("audio_rate")
	arate.set_value(chapter_to_modify[9])
	w=arbol.get_widget("audiodelay")
	w.set_value(chapter_to_modify[14])
	if chapter_to_modify[12]==0:
		w=arbol.get_widget("blackbars")
		w.set_active(True)
	else:
		w=arbol.get_widget("scalepict")
		w.set_active(True)
		
	w=arbol.get_widget("do_chapters")
	if chapter_to_modify[13]==0:
		w.set_active(False)
		w=arbol.get_widget("chapter_long")
		w.set_sensitive(False)
	else:
		w.set_active(True)
		w=arbol.get_widget("chapter_long")
		w.set_sensitive(True)
		w.set_value(chapter_to_modify[13])
		
	if chapter_to_modify[15]==25:
		w=arbol.get_widget("video_pal")
	else:
		w=arbol.get_widget("video_ntsc")
	w.set_active(True)
	
	if chapter_to_modify[19]==0:
		w=arbol.get_widget("full_length")
	elif chapter_to_modify[19]==1:
		w=arbol.get_widget("first_half")
	else:
		w=arbol.get_widget("second_half")
	w.set_active(True)
	refresh_film_data()
	new_chapter=[]
	filechoser=arbol.get_widget("moviefile")
	filechoser.set_filename(chapter_to_modify[1])
	wfile.show()

def chapter_changed(args):

	global arbol
	
	w=arbol.get_widget("chapter_long")
	w.set_sensitive(args.get_active())

def empty_no(args):

	global wempty_titles
	
	wempty_titles.hide()

def empty_yes(args):

	global wempty_titles
	
	wempty_titles.hide()
	create_dvd2()

def create_dvd(args):

	global structure
	global arbol
	global erase_temporary_files
	
	w=arbol.get_widget("erase_files")
	if w.get_active()==True:
		print "Borro"
		erase_temporary_files=True
	else:
		print "No borro"
		erase_temporary_files=False
	
	vacio=False
	for elemento in structure:
		if len(elemento)<2:
			vacio=True
			break
	
	if vacio:
		wempty_titles.show()
	else:
		create_dvd2()

def cancel_progress(args):

	global cancel_prog
	
	cancel_prog=True

def folder_return(args):

	global arbol

	wfolder=arbol.get_widget("wfolder")
	wfolder.hide()
	

def create_dvd2():

	global arbol
	global wfolder
	
	w=arbol.get_widget("directorio_final")
	w.set_filename("")
	w.set_current_folder("")
	w=arbol.get_widget("iso_name")
	w.set_text("movie")
	

	iso_changed("")
	wfolder.show()
	
def iso_changed(args):

	global arbol
	
	iso_name=arbol.get_widget("iso_name")
	iso_folder=arbol.get_widget("directorio_final")
	
	w=arbol.get_widget("folder_accept")
	
	mode=True
	
	if iso_name.get_text()=="":
		mode=False
		
	folder=iso_folder.get_filename()
	if folder==None:
		mode=False
	elif folder=="":
		mode=False
		
	w.set_sensitive(mode)

def convert_file(afile,filefolder,filename,cfiles,titles,files,total,seconds=0):

	global cancel_prog
	global arbol
	global disctocreate
	
	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")

	if cancel_prog:
		return True
	addbars=False
	framerate=int(afile[5])
	videorate=int(afile[8])
	audiorate=int(afile[9])
	audio_final_rate=int(afile[16])
	audiodelay=float(afile[14])
	final_framerate=float(afile[15])
	aspect_ratio_original=afile[17]
	aspect_ratio_final=afile[18]
	
	if aspect_ratio_original<1.33:
		aspect_ratio_original=float(afile[2])/(float(afile[3]))
	if aspect_ratio_original<1.33333333:
		aspect_ratio_original=1.33333333
	max_videorate=int(videorate*1.5)
	if disctocreate=="vcd":
		max_videorate=1150
	elif (disctocreate=="svcd") or (disctocreate=="cvd"):
		if max_videorate>2375:
			max_videorate=2375
	elif (disctocreate=="dvd"):
		if max_videorate>8500:
			max_videorate=8500
	else:
		print ("Error, disc format is not DVD, VCD, SVCD or CVD. Contact with the author")
		sys.exit(1)

	resx_final=afile[10]
	resy_final=afile[11]
	resx_original=afile[2]
	resy_original=afile[3]
	
	if afile[12]==0: # check if has to add black bars
		addbars=True
		if (resx_original%2)==1:
			resx_original+=1
		if (resy_original%2)==1:
			resy_original+=1
		resx_inter=resx_original
		resy_inter=int((resy_original*aspect_ratio_original)/aspect_ratio_final)
		if (resy_inter%2)==1:
			resy_inter+=1
		if ((resy_inter<resy_original) or (resy_original+5>resy_inter)):
			addbars=False # due to a bug in MENCODER, we put bars only up and down, never left and right
						# and we don't scale it if we have to add only 4 or less lines, because is too much work for little profit
	
	if addbars==False:
		resx_inter=resx_original
		resy_inter=resy_original
	else:
		addx=0
		addy=int((resy_inter-resy_original)/2)

	command_var=["mencoder"]
	if disctocreate=="dvd":
		audio_desired_final_rate=48000
	else:
		audio_desired_final_rate=44100

	if audio_final_rate!=audio_desired_final_rate:
		command_var.append("-srate")
		command_var.append(str(audio_desired_final_rate))
		command_var.append("-af")
		command_var.append("lavcresample="+str(audio_desired_final_rate))

	command_var.append("-oac")
	command_var.append("lavc")
	command_var.append("-ovc")
	command_var.append("lavc")
	command_var.append("-of")
	command_var.append("mpeg")
	command_var.append("-mpegopts")
	if disctocreate=="dvd":
		command_var.append("format=dvd")
	elif disctocreate=="vcd":
		command_var.append("format=xvcd")
	elif (disctocreate=="svcd") or (disctocreate=="cvd"):
		command_var.append("format=xsvcd")
	else:
		print "Error, disc format incorrect. Talk with the creator."
		sys.exit(1)
	
	halffile=False
	if seconds!=0:
		command_var.append("-endpos")
		command_var.append(str(seconds))
	else:
		if afile[19]==1: # first half only
			command_var.append("-endpos")
			command_var.append(str(afile[4]/2))
			halffile=True
		elif afile[19]==2: # second half only
			command_var.append("-ss")
			command_var.append(str((afile[4]/2)-5)) # start 5 seconds before
			halffile=True

	if audiodelay!=0.0:
		command_var.append("-delay")
		command_var.append(str(audiodelay))

	if final_framerate==30:
		str_final_framerate="30000/1001"
		keyintv=18
	else:
		str_final_framerate=str(int(final_framerate))
		keyintv=15
	
	command_var.append("-ofps")
	command_var.append(str_final_framerate)

	command_var.append("-vf")
	lineatemp=""
	if addbars and ((resx_inter!=resx_original) or (resy_inter!=resy_original)):
		lineatemp+="expand="+str(resx_inter)+":"+str(resy_inter)+":"+str(addx)+":"+str(addy)+","

	if (resx_inter!=resx_final) or (resy_inter!=resy_final):
		lineatemp+="scale="+str(resx_final)+":"+str(resy_final)+","
	lineatemp+="harddup"
	command_var.append(lineatemp)
	command_var.append("-lavcopts")
	lavcopts="vcodec="
	if disctocreate=="vcd":
		lavcopts+="mpeg1video"
	else:
		lavcopts+="mpeg2video"
	lavcopts+=":vmax_b_frames=2:vrc_maxrate="+str(max_videorate)+":vrc_buf_size="
	
	if (disctocreate=="vcd"):
		lavcopts+="327"
	elif (disctocreate=="svcd") or (disctocreate=="cvd"):
		lavcopts+="917"
	elif (disctocreate=="dvd"):
		lavcopts+="1835"
	
	lavcopts+=":vbitrate="+str(videorate)+":keyint="+str(keyintv)+":acodec="
	if disctocreate=="dvd":
		lavcopts+="ac3"
	else:
		lavcopts+="mp2"
	lavcopts+=":abitrate="+str(audiorate)+":aspect=4/3"
	
	command_var.append(lavcopts)
	
	currentfile=filefolder+filename+"_"
	if titles<10:
		currentfile+="0"
	currentfile+=str(titles)+"_"
	if files<10:
		currentfile+="0"
	currentfile+=str(files)+'.mpg'
	
	command_var.append("-o")
	command_var.append(currentfile)
	command_var.append(afile[1])
	
	extra_params=afile[21] # take the extra params
	while (extra_params!=""):
		extra_params,new_param=get_new_param(extra_params)
		if new_param!="":
			command_var.append(new_param)
	
	percent2=120
	refresh=False
	
	busqueda=re.compile("Pos:[0-9 ]*\.[0-9]s")
	if seconds==0:
		divide=float(afile[4])
		ppartial.show()
	else:
		divide=float(seconds)
		ppartial.hide()
	if divide==0:
		divide=1
	
	espera=False
	salta=False
	handler=launch_program(command_var)
	while True:
		v1,v2,v3=select.select([handler.stderr,handler.stdout],[],[],0)
		if (len(v1)==0):
			if espera:
				refresh_screen()
				time.sleep(.1)
				salta=False
			continue
		for elem in v1:
			if elem==handler.stderr:
				temporal=handler.stderr.readline(80)
				print temporal,
			else:
				linea=handler.stdout.readline(2400)
				if linea=="":
					break
				if cancel_prog:
					break
				if linea[-1]=="\n":
					print linea,
					break
				if salta:
					break
				salta=True
				pos=linea.find("Pos:")
				if pos==-1:
					break
				espera=True
				while(pos+10)>len(linea):
					linea+=handler.stdout.read(2)
				elemento=busqueda.findall(linea)
				if len(elemento)==0:
					break
				valuetemp=float(elemento[0][4:-1])
				if (halffile):
					valuetemp*=2
				value=(100*valuetemp)/divide
				refresh=False
				if (value!=percent2) or (percent2==120):
					percent1=((100*cfiles)/total)+(value/total)
					ptotal.set_fraction(percent1/100)
					ptotal.set_text(str(int(percent1))+"%")
					if seconds==0:
						texto=_("Converting files from title ")
						label.set_text(texto+str(titles)+"\n"+afile[0])
					else:
						texto=_("Creating preview\n")
						label.set_text(texto+afile[0])
					if (value)>100:
						value=100
					ppartial.set_fraction(value/100)
					percent2=value
					ppartial.set_text(str(int(percent2))+"%")
					refresh=True
		if (linea=="") or cancel_prog:
			break
		if linea[-1]=="\n":
			continue
	if cancel_prog:
		os.kill(handler.pid,signal.SIGKILL)
	handler.wait()
	retcode=handler.returncode
	if (retcode!=0) or cancel_prog:
		print "Deleting "+currentfile+" due to error or aborting."
		p=subprocess.Popen('rm "'+currentfile+'"',shell=True,bufsize=32768)
		p.wait()
		if not cancel_prog:
			cause=1
		cancel_prog=True
		return True
	else:
		return False


def create_dvd3(args):

	global wmain
	global arbol
	global structure
	global cancel_prog
	global wprogress
	global returnmain
	global disctocreate
	global erase_temporary_files
	
	wmain.hide()
	
	tiempo=time.time()
	
	cancel_prog=False
	
	w=arbol.get_widget("wfolder")
	w.hide()
	
	w=arbol.get_widget("directorio_final")
	filefolder=w.get_filename()
	
	actions=0
	
	w=arbol.get_widget("only_convert")
	if w.get_active():
		actions=1
	else:
		w=arbol.get_widget("create_dvd")
		if (w.get_active()) or (disctocreate!="dvd"):
			actions=2
		else:
			actions=3
	
	estado=os.statvfs(filefolder)
	total=calcula_tamano_total()
	freespace=estado.f_bsize*estado.f_bavail/1000
	print "Libre: "+str(freespace)
	print "Necesario: "+str(total)
	
	if (actions!=3):
		total*=actions
	else:
		if erase_temporary_files:
			total*=2
		else:
			total*=3
	total*=1.1 # a safe margin of 10%
	
	if (freespace<total):
		w=arbol.get_widget("error2_label")
		w.set_text(_("Insuficient free space. To create this disk\n%(total)d MBytes are needed, but only %(free)d MBytes are available." % {'total':int(total/1000),'free':int(freespace/1000)}))
		w=arbol.get_widget("werror2")
		returnmain=w			
		w.show()			
		return
	
	w=arbol.get_widget("iso_name")
	filename2=w.get_text()
	filename=""
	for letra in filename2:
		if letra==" ":
			filename+="_"
		else:
			filename+=letra
	print "Fichero :"+filename
	
	
	if filefolder[-1]!="/":
		filefolder+="/"
	
	cancel_prog=False

	os.nice(1) # less priority to allow to use the computer without speed penalty while compressing

	ppartial=arbol.get_widget("progresspartial")
	ptotal=arbol.get_widget("progress_total")
	label=arbol.get_widget("lcreating")
	
	wprogress.show()
	refresh_screen()
	refresh_screen()
	total=0
	
	for elemento in structure:
		total+=((len(elemento))-1)
	total+=(actions-1)
	
		
	try:
		fichero=open(filefolder+filename+".xml","w")
		fichero.write('<dvdauthor dest="'+filefolder+filename+'">\n')
		fichero.write("<vmgm> </vmgm>\n<titleset>\n<titles>\n")
		titles=0
		for elemento in structure:
			titles+=1
			fichero.write("<pgc>\n")
			if len(elemento)>1:
				files=0
				for elemento2 in elemento[1:]:
					files+=1
					currentfile=filefolder+filename+"_"
					if titles<10:
						currentfile+="0"
					currentfile+=str(titles)+"_"
					if files<10:
						currentfile+="0"
					currentfile+=str(files)+'.mpg'
					fichero.write('<vob file="'+currentfile+'" ')
					if elemento2[13]!=0: # add chapters
						minutes=0
						curr_second=0
						hours=0
						fichero.write('chapters="')
						toadd=int(elemento2[13])
						while curr_second<elemento2[4]:
							if (minutes==0) and (hours==0):
								fichero.write("0")
							else:
								fichero.write(",")
								if hours!=0:
									if hours<10:
										fichero.write("0")
									fichero.write(str(hours)+":")
								if minutes<10:
									fichero.write("0")
								fichero.write(str(minutes)+":00")
							minutes+=toadd
							if minutes>59:
								minutes-=60
								hours+=1
							curr_second+=(60*toadd)
						fichero.write('" ')
					#else:
					#	fichero.write('chapters="0" ');
					fichero.write('/>\n')
				fichero.write("</pgc>\n")
		fichero.write("</titles>\n</titleset>\n</dvdauthor>")
		fichero.close()
	except IOError:
		wprogress.hide()
		w=arbol.get_widget("error2_label")
		w.set_text(_("Failed to write to the destination directory.\nCheck that you have privileges and free space there."))
		w=arbol.get_widget("werror2")
		returnmain=w			
		w.show()			
		return
	
	resx_inter=0
	resy_inter=0
	addx=0
	addy=0
	titles=0
	cfiles=0.0
	percent1=0
	counter=0
	cause=0
	
	for title in structure:
		if cancel_prog:
			break
		titles+=1
		if len(title)>1:
			files=0
			for afile in title[1:]:
				files+=1
				if False==convert_file(afile,filefolder,filename,cfiles,titles,files,total):
					cfiles+=1.0
				else:
					break
				
	if cancel_prog:
		wprogress.hide()
		if cause==0:
			w=arbol.get_widget("w_aborted")
			returnmain=w
			w.show()
			return
		if cause==1:
			w=arbol.get_widget("error2_label")
			if percent2==120: # still hadn't take a value, so it seems it failed (core dump)
				w.set_text(_("Conversion failed.\nIt seems a bug of Mencoder."))
			else:
				w.set_text(_("Conversion failed\nMaybe you ran out of disk space?"))
			w=arbol.get_widget("werror2")
			returnmain=w			
			w.show()			
			return


	if (actions>1) and (disctocreate=="dvd"):
		print "convirtiendo DVD"
		label.set_text(_("Creating DVD tree structure"))
		total2=0
		total_films=total-1
		percent1=float((100*(total-2))/total)
		ptotal.set_fraction(percent1/100)
		ptotal.set_text(str(int(percent1))+"%")
		ppartial.set_fraction(0)
		ppartial.set_text("0%")
		handler=launch_program(["dvdauthor","-x",filefolder+filename+".xml"])
		refresh_screen()
		while True:
			v1,v2,v3=select.select([handler.stdout,handler.stderr],[],[])
			for elem in v1:
				temporal=elem.readline(80)
				print temporal,
				if temporal=="":
					break
				if len(temporal)>11:
					if temporal[0:11]=="INFO: Video":
						total2+=1
						percent2=float((100*total2)/total_films)
						percent1=float((100*(total-2))/total)+(percent2/total)
						ptotal.set_fraction(percent1/100)
						ptotal.set_text(str(int(percent1))+"%")
						ppartial.set_fraction(percent2/100)
						ppartial.set_text(str(int(percent2))+"%")
			refresh_screen()
			if (temporal=="") or (cancel_prog):
				break
		cause=0
		if cancel_prog:
			os.kill(handler.pid,signal.SIGKILL)
		handler.wait()
		retcode=handler.returncode
		if retcode!=0:
			cause=1
			cancel_prog=True
		if cancel_prog:
			wprogress.hide()
			if cause==0:
				w=arbol.get_widget("w_aborted")
				returnmain=w
				w.show()
				return
			if cause==1:
				w=arbol.get_widget("error2_label")
				w.set_text(_("Failed to create the DVD tree\nMaybe you ran out of disk space"))
				w=arbol.get_widget("werror2")
				returnmain=w				
				w.show()			
				return
		if erase_temporary_files:
			print "Deleting temporary files: "+filename+"_??_??.mpg and .xml"
			handle=subprocess.Popen("rm "+filefolder+filename+"_??_??.mpg",bufsize=8192,shell=True)
			handle.wait()
			handle=subprocess.Popen("rm "+filefolder+filename+".xml",bufsize=8192,shell=True)
			handle.wait()
	
	
	if (actions>1) and (disctocreate!="dvd"):
		cancel_prog=False
		print "Convirtiendo xCD"
		label.set_text(_("Creating BIN/CUE files"))
		cantidad=len(structure[0])-1
		lista=["vcdimager","-c",filefolder+filename+".cue","-b",filefolder+filename+".bin","-t"]
		if disctocreate=="vcd":
			lista.append("vcd2")
		else:
			lista.append("svcd")
		for variable in range(cantidad):
			currentfile=filefolder+filename+"_01_"
			if variable<10:
				currentfile+="0"
			currentfile+=str(variable+1)+".mpg"
			lista.append(currentfile)
		ppartial.set_text(_("Unknown"))
		ppartial.set_fraction(0)
		cause=0
		cancel_prog=False
		refresh_screen()
		handler=launch_program(lista,False)
		handler.wait()
		retcode=handler.returncode
		if retcode!=0:
			cause=1
			cancel_prog=True
		if cancel_prog:
			wprogress.hide()
			if cause==0:
				w=arbol.get_widget("w_aborted")
				returnmain=w
				w.show()
				return
			if cause==1:
				w=arbol.get_widget("error2_label")
				w.set_text(_("Failed to create the BIN/CUE files\nMaybe you ran out of disk space"))
				w=arbol.get_widget("werror2")
				returnmain=w				
				w.show()			
				return
		
		if erase_temporary_files:
			print "Deleting temporary files: "+filename+"_01_??.mpg and .xml"
			handle=subprocess.Popen("rm "+filefolder+filename+"_01_??.mpg",bufsize=8192,shell=True)
			handle.wait()
			handle=subprocess.Popen("rm "+filefolder+filename+".xml",bufsize=8192,shell=True)
			handle.wait()

	if actions>2:
		label.set_text(_("Creating ISO file"))
		percent1=float((100*(total-1))/total)
		ptotal.set_fraction(percent1/100)
		ptotal.set_text(str(int(percent1))+"%")
		ppartial.set_fraction(0)
		ppartial.set_text("0%")
		handler=launch_program(["mkisofs","-dvd-video","-v","-o",filefolder+filename+".iso",filefolder+filename])
		refresh_screen()
		while True:
			v1,v2,v3=select.select([handler.stdout,handler.stderr],[],[])
			for elem in v1:
				temporal=elem.readline(80)
				if temporal=="":
					break
				punto=temporal.find("done, estimate")
				if (punto!=-1):
					if ((temporal[2].isdigit()) and ((temporal[1].isdigit()) or (temporal[1]==" "))):
						percent2=float(temporal[1:3])
						percent1=float(((100*(total-1))/total)+(percent2/total))
						ptotal.set_fraction(percent1/100)
						ptotal.set_text(str(int(percent1))+"%")
						ppartial.set_fraction(percent2/100)
						ppartial.set_text(str(int(percent2))+"%")
				else:
					print temporal,
			refresh_screen()
			if (temporal=="") or (cancel_prog):
				break
		cause=0
		if cancel_prog:
			os.kill(handler.pid,signal.SIGKILL)
		handler.wait()
		retcode=handler.returncode
		if retcode!=0:
			cause=1
		if cancel_prog:
			wprogress.hide()
			if cause==0:
				w=arbol.get_widget("w_aborted")
				returnmain=w
				w.show()
				return
			if cause==1:
				w=arbol.get_widget("error2_label")
				w.set_text(_("Failed to create the ISO image\nMaybe you ran out of disk space"))
				w=arbol.get_widget("werror2")
				returnmain=w				
				w.show()			
				return
		if erase_temporary_files:
			print "erasing DVD tree folder"
			handle=subprocess.Popen("rm -rf "+filefolder+filename,bufsize=8192,shell=True)
			handle.wait()
			
			

	wprogress.hide()
	tiempo2=time.time()-tiempo
	segundos=int(tiempo2%60)
	minutos=int((tiempo2/60)%60)
	horas=int(tiempo2/3600)
	print int(tiempo2)
	w=arbol.get_widget("elapsed")
	w.set_text((_("Elapsed time: "))+str(horas)+":"+str(minutos)+":"+str(segundos))
	w=arbol.get_widget("w_end")
	w.show()

def return_main(args):

	global returnmain
	
	if returnmain!=None:
		returnmain.hide()
		
	wmain.show()

def refresh_screen():
	
	while gtk.events_pending():
		gtk.main_iteration()

def exit_program(args):

	gtk.main_quit()

def alwaystrue(args="",arg2=""):

	return True

def check_program(programa):
	
	p=subprocess.Popen(programa+" >/dev/null 2>/dev/null",shell=True)
	p.wait()
	return p.returncode

def separa_dnd(datos):

	lista=[]
	item=""
	tempo=""
	modo=0
	for elemento in datos:
		if (elemento=="\n") and (item!=""):
			if item[:8]=="file:///":
				lista.append(item[7:])
				item=""
				continue
		if ord(elemento)<32:
			continue
		if modo==0:
			if elemento=="%":
				modo=1
			else:
				item+=elemento
		elif modo==1:
			tempo=elemento
			modo=2
		else:
			modo=0
			item+=chr(int(tempo+elemento,16))
	return lista

def draganddrop_two(widget,drag_context, x, y, selection, info, time):

	global arbol
	global returnmain

	lista=separa_dnd(selection.data)

	if len(lista)==0:
		return

	if len(lista)>1:
		w=arbol.get_widget("error2_label")
		w.set_text(_("Please, add only one file each time.\n"))
		w=arbol.get_widget("werror2")
		returnmain=w
		w.show()
		return

	w=arbol.get_widget("moviefile")
	w.set_filename(lista[0])

def draganddrop(widget,drag_context, x, y, selection, info, time):
	
	global arbol
	global structure
	global returnmain

	lista=separa_dnd(selection.data)
	fine=True
	lista2=[]
	for elemento in lista:
		done,audio=set_values_of_file(elemento,True) # check if files are videos
		print done
		print audio
		if (done==False):
			fine=False
			break
		
		lista2.append(new_chapter)
	
	if fine:
		titulo,capitulo=get_marked()
		elemento=structure[titulo]
		for elemento2 in lista2:
			elemento.append(elemento2)
		refresh_chapters()
		set_buttons()
				
	else:
		w=arbol.get_widget("error2_label")
		w.set_text(_("Some files weren't video files.\nNone added.\n"))
		w=arbol.get_widget("werror2")
		returnmain=w
		w.show()

def set_resolution(palvalue):

	global arbol
	
	if palvalue:
		res1="288"
		res2="576"
	else:
		res1="240"
		res2="480"

	w=arbol.get_widget("res720x480")
	w.set_label("720x"+res2)
	w=arbol.get_widget("res704x480")
	w.set_label("704x"+res2)
	w=arbol.get_widget("res480x480")
	w.set_label("480x"+res2)
	w=arbol.get_widget("res352x480")
	w.set_label("352x"+res2)
	w=arbol.get_widget("res352x240")
	w.set_label("352x"+res1)
	
def init_main():

	global wmain
	global returnmain
	global arbol
	global ltitles
	global lchapters
	global del_title
	global add_chapter
	global del_chapter
	global prop_chapter
	global main_go
	global wdel_title
	global wfile
	global wabout
	global werror
	global wdel_chapter
	global wempty_titles
	global wprogress
	global wfolder
	global wprograms
	global wpreview
	global wreplay
	global title_down
	global title_up
	global files_down
	global files_up
	global wdisktype
	
	returnmain=None
	
	wdisktype=arbol.get_widget("wdisktype")
	wdisktype.connect("delete_event",wmain_delete)
	
	title_down=arbol.get_widget("titledown")
	title_down.connect("clicked",titledown)
	
	title_up=arbol.get_widget("titleup")
	title_up.connect("clicked",titleup)
	
	files_down=arbol.get_widget("filesdown")
	files_down.connect("clicked",filesdown)
	
	files_up=arbol.get_widget("filesup")
	files_up.connect("clicked",filesup)
	
	w=arbol.get_widget("directorio_final")
	w.connect("selection-changed",iso_changed)
	
	wfolder=arbol.get_widget("wfolder")
	wfolder.connect("delete_event",global_delete)
	
	wprogress=arbol.get_widget("wprogress")
	wprogress.connect("delete_event",alwaystrue)
	
	wabout=arbol.get_widget("aboutdialog1")
	wabout.connect("delete_event",global_delete)
	
	wmain=arbol.get_widget("wmain")
	wmain.connect("delete_event",wmain_delete)
	
	w=arbol.get_widget("main_cancel")
	w.connect("clicked",wmain_delete)
	
	w=arbol.get_widget("about")
	w.connect("clicked",show_about)
	
	w=arbol.get_widget("prog_cancel")
	w.connect("clicked",cancel_progress)
	
	ltitles=arbol.get_widget("ltitles")
	lchapters=arbol.get_widget("lchapters")
	
	wmain.drag_dest_set(gtk.DEST_DEFAULT_MOTION | gtk.DEST_DEFAULT_HIGHLIGHT | gtk.DEST_DEFAULT_DROP,[ ( "text/plain", 0, 80 ) ],gtk.gdk.ACTION_COPY)
	wmain.connect("drag_data_received",draganddrop)
	
	ltitles.set_model(list_titles)
	lchapters.set_model(list_chapters)
	
	renderertitles=gtk.CellRendererText()
	columntitles = gtk.TreeViewColumn("Title", renderertitles, text=1)
	ltitles.append_column(columntitles)
	
	rendererchapters=gtk.CellRendererText()
	columnchapters = gtk.TreeViewColumn("Title", rendererchapters, text=1)
	lchapters.append_column(columnchapters)
	
	ltitles.connect("button_release_event",titleclick)
	lchapters.connect("button_release_event",chapterclick)
	
	add_title=arbol.get_widget("add_title")
	add_title.connect("clicked",addtitle)
	del_title=arbol.get_widget("del_title")
	del_title.connect("clicked",deltitle)
	add_chapter=arbol.get_widget("add_chapter")
	add_chapter.connect("clicked",addchapter)
	del_chapter=arbol.get_widget("del_chapter")
	del_chapter.connect("clicked",delete_chapter)
	prop_chapter=arbol.get_widget("prop_chapter")
	prop_chapter.connect("clicked",modify_chapter)
	main_go=arbol.get_widget("main_go")
	main_go.connect("clicked",create_dvd)
	
	w=arbol.get_widget("create_iso")
	w.set_active(True)
	
	wdel_title=arbol.get_widget("wdel_title")
	wdel_title.connect("delete_event",global_delete)
	w=arbol.get_widget("deltitle_yes")
	w.connect("clicked",delete_title)
	w=arbol.get_widget("deltitle_no")
	w.connect("clicked",no_delete_title)
	
	wdel_chapter=arbol.get_widget("wdel_chapter")
	wdel_chapter.connect("delete_event",global_delete)
	w=arbol.get_widget("delchapter_yes")
	w.connect("clicked",delete_chapter_yes)
	w=arbol.get_widget("delchapter_no")
	w.connect("clicked",delete_chapter_no)
	
	wempty_titles=arbol.get_widget("wempty_titles")
	wempty_titles.connect("delete_event",global_delete)
	w=arbol.get_widget("empty_yes")
	w.connect("clicked",empty_yes)
	w=arbol.get_widget("empty_no")
	w.connect("clicked",empty_no)
	
	w=arbol.get_widget("dvdsize")
	w.set_active(0)
	w.connect("changed",dvd_changed)
	
	wfile=arbol.get_widget("wfile")
	wfile.connect("delete_event",global_delete)
	wfile.drag_dest_set(gtk.DEST_DEFAULT_MOTION | gtk.DEST_DEFAULT_HIGHLIGHT | gtk.DEST_DEFAULT_DROP,[ ( "text/plain", 0, 80 ) ],gtk.gdk.ACTION_COPY)
	wfile.connect("drag_data_received",draganddrop_two)
	
	w=arbol.get_widget("filecancel")
	w.connect("clicked",chaptercancel)
	w=arbol.get_widget("moviefile")
	w.connect("selection-changed",filechanged)
	
	werror=arbol.get_widget("werror")
	werror.connect("delete_event",global_delete)
	w=arbol.get_widget("error_ok")
	w.connect("clicked",errorok)
	
	w=arbol.get_widget("video_rate")
	w.connect("value_changed",value_changed)
	w=arbol.get_widget("audio_rate")
	w.connect("value_changed",value_changed)
	w=arbol.get_widget("video_pal")
	w.connect("toggled",value_changed)
	
	w=arbol.get_widget("fileaccept")
	w.connect("clicked",add_a_file)
	
	w=arbol.get_widget("do_chapters")
	w.connect("clicked",chapter_changed)
	
	w=arbol.get_widget("msgno")
	w.connect("clicked",noabort)
	w=arbol.get_widget("msgyes")
	w.connect("clicked",siabort)
	
	w=arbol.get_widget("folder_cancel")
	w.connect("clicked",folder_return)
	w=arbol.get_widget("folder_accept")
	w.connect("clicked",create_dvd3)
	w=arbol.get_widget("iso_name")
	w.connect("changed",iso_changed)
	
	w=arbol.get_widget("button_aborted")
	w.connect("clicked",return_main)
	w=arbol.get_widget("w_aborted")
	w.connect("delete_event",alwaystrue)
	w=arbol.get_widget("error2_button")
	w.connect("clicked",return_main)
	w=arbol.get_widget("werror2")
	w.connect("delete_event",alwaystrue)
	w=arbol.get_widget("end_button")
	w.connect("clicked",exit_program)
	w=arbol.get_widget("w_end")
	w.connect("delete_event",alwaystrue)
	
	wpreview=arbol.get_widget("wpreview")
	wpreview.connect("delete_event",global_delete)
	
	wprograms=arbol.get_widget("wprograms")
	wprograms.connect("delete_event",alwaystrue)
	w=arbol.get_widget("program_exit")
	w.connect("clicked",exit_program)
	
	w=arbol.get_widget("preview_film")
	w.connect("clicked",preview_film)
	w=arbol.get_widget("preview_cancel")
	w.connect("clicked",preview_cancel)
	w=arbol.get_widget("preview_ok")
	w.connect("clicked",preview_ok)
	
	wreplay=arbol.get_widget("wreplay")
	wreplay.connect("delete_event",global_delete)
	
	w=arbol.get_widget("replay_yes")
	w.connect("clicked",play_preview)
	
	w=arbol.get_widget("replay_no")
	w.connect("clicked",noreplay)
	
	w=arbol.get_widget("full_length")
	w.connect("toggled",value_changed)
	
	w=arbol.get_widget("first_half")
	w.connect("toggled",value_changed)
	
	w=arbol.get_widget("typedvd")
	w.connect("clicked",select_dvd)
	w=arbol.get_widget("typevcd")
	w.connect("clicked",select_vcd)
	w=arbol.get_widget("typesvcd")
	w.connect("clicked",select_svcd)
	w=arbol.get_widget("typecvd")
	w.connect("clicked",select_cvd)
	w=arbol.get_widget("resauto")
	w.set_active(True)
	w.connect("toggled",value_changed)
	w=arbol.get_widget("res720x480")
	w.connect("toggled",value_changed)
	w=arbol.get_widget("res704x480")
	w.connect("toggled",value_changed)
	w=arbol.get_widget("res480x480")
	w.connect("toggled",value_changed)
	w=arbol.get_widget("res352x480")
	w.connect("toggled",value_changed)
	w=arbol.get_widget("res352x240")
	w.connect("toggled",value_changed)
	
	refresh_titles()
	set_buttons()
	
def noreplay(args):

	global wreplay
	
	wreplay.hide()
	launch_program(["rm", "/var/tmp/movietemp_01_01.mpg"],False)

def preview_film(args):

	global wpreview
	global arbol
		
	w=arbol.get_widget("seconds_preview")
	w.set_value(60)
	wpreview.show()

def preview_cancel(args):

	global wpreview
	
	wpreview.hide()

def preview_ok(args):

	global wpreview
	global arbol
	global wprogress
	global cancel_prog
	global wreplay
	
	set_file_values()
	wpreview.hide()
	w=arbol.get_widget("seconds_preview")
	wprogress.show()
	cancel_prog=False
	retorno=convert_file(new_chapter,"/var/tmp/","movietemp",0.0,1,1,1,w.get_value())
	wprogress.hide()
	if retorno==False:
		play_preview("")
	
def play_preview(args):

	global wreplay
	
	wreplay.hide()
	parameters=["mplayer","/var/tmp/movietemp_01_01.mpg"]
	salida=launch_program(parameters,False)
	salida.wait()
	wreplay.show()

def load_config():

	global PAL
	
	PAL=True
	
	home=os.environ.get("HOME")
	if home[-1]!="/":
		home+="/"
	home+=".devede"
	try:
		archivo=open(home,"r")
		linea=archivo.readline()
		if linea=="ntsc\n":
			PAL=False
		archivo.close()
	except IOError:
		PAL=True

def select_first():

	global ltitles
	global lchapters
	global wmain

	wmain.show()
	ltitles.get_selection().select_path( (0,))
	lchapters.get_selection().select_path( (0,))
	
	set_buttons()

def select_dvd(args):

	global disctocreate
	global wdisktype
	global arbol
	
	disctocreate="dvd"
	wdisktype.hide()
	w=arbol.get_widget("dvdsize")
	w.set_active(4)
	select_first()

def select_vcd(args):

	global disctocreate
	global wdisktype
	global arbol
	
	disctocreate="vcd"
	wdisktype.hide()
	w=arbol.get_widget("dvdsize")
	w.set_active(2)
	select_first()
	w=arbol.get_widget("frame1")
	w.hide()
	w=arbol.get_widget("create_dvd")
	w.hide()
	w=arbol.get_widget("frame_division")
	w.hide()

def select_svcd(args):

	global disctocreate
	global wdisktype
	global arbol
	
	disctocreate="svcd"
	wdisktype.hide()
	w=arbol.get_widget("dvdsize")
	w.set_active(2)
	select_first()
	w=arbol.get_widget("frame1")
	w.hide()
	w=arbol.get_widget("create_dvd")
	w.hide()
	w=arbol.get_widget("frame_division")
	w.hide()

def select_cvd(args):

	global disctocreate
	global wdisktype
	global arbol
	
	disctocreate="cvd"
	wdisktype.hide()
	w=arbol.get_widget("dvdsize")
	w.set_active(2)
	select_first()
	w=arbol.get_widget("frame1")
	w.hide()
	w=arbol.get_widget("create_dvd")
	w.hide()
	w=arbol.get_widget("frame_division")
	w.hide()

def save_config():

	global PAL
	
	home=os.environ.get("HOME")
	if home[-1]!="/":
		home+="/"
	home+=".devede"
	try:	
		archivo=open(home,"w")
		if PAL:
			archivo.write("pal\n")
		else:
			archivo.write("ntsc\n")
		archivo.close()
	except IOError:
		pass

def get_new_param(parameters):

	new_param=""
	
	while(True):
		if (parameters.find(" ")==0):
			parameters=parameters[1:] # erase blank spaces at start
		else:
			break

	if len(parameters)==0:
		return "",""
	
	p0=0
	while True:
		p1=parameters.find('\\',p0)
		p2=parameters.find(' ',p0)
		if p2==p1+1:
			p0=p2+1
		else:
			if p2<0: # no next space, take all the string
				retorno=""
				doble=False
				print parameters
				for letra in parameters:
					if (letra!='\\') or doble:
						retorno+=letra
						doble=False
					else:
						doble=True
				return "",retorno
			else:
				retorno=""
				doble=False
				print parameters[:p2]
				for letra in parameters[:p2]:
					if (letra!='\\') or doble:
						retorno+=letra
						doble=False
					else:
						doble=True
				return parameters[p2+1:],retorno

print "DeVeDe 2.1 alfa 2"

home=os.environ.get("HOME")
if home[-1]!="/":
	home+="/"

locale.setlocale(locale.LC_ALL,"")
gettext.textdomain('devede')
_ = gettext.gettext

try:
	gettext.bindtextdomain('devede', '/usr/share/locale')
	#gtk.glade.bindtextdomain ('devede', '/usr/share/locale/')
	arbol=gtk.glade.XML("/usr/share/devede/devede.glade",domain="devede")
except RuntimeError:
	gettext.bindtextdomain('devede', './')
	#gtk.glade.bindtextdomain ('devede', './')
	arbol=gtk.glade.XML("devede.glade",domain="devede")

load_config()

list_titles=gtk.TreeStore(gobject.TYPE_PYOBJECT,gobject.TYPE_STRING)
list_chapters=gtk.TreeStore(gobject.TYPE_PYOBJECT,gobject.TYPE_STRING)

structure=[[_("Title")+"1"]]

init_main()

errors=""
if 127==check_program("mplayer -v"):
	errors+="mplayer\n"
if 127==check_program("mencoder -msglevel help"):
	errors+="mencoder\n"
if 127==check_program("dvdauthor --help"):
	errors+="dvdauthor\n"
if 127==check_program("vcdimager --help"):
	errors+="vcdimager\n"
if 127==check_program("mkisofs -help"):
	errors+="mkisofs\n"

if errors!="":
	w=arbol.get_widget("programs_label")
	w.set_text(errors)
	wprograms.show()
else:
	wdisktype.show()

gtk.main()
