/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.WizardStepPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WizardPanel
extends JPanel
implements ActionListener {
    private Vector stepPanels;
    private int stepCurrent;
    private int stepLast;
    private JPanel stepButtons;
    private JButton[] stepBtns;
    private JPanel currentPanel;
    public final int BTN_BACK = 0;
    public final int BTN_NEXT = 1;
    public final int BTN_FINISH = 2;
    public final int BTN_CANCEL = 3;
    private String[] stepBtnsStrings = new String[]{"Back", "Next", "Finish", "Cancel"};

    public WizardPanel(WizardStepPanel firstStepPanel) {
        if (firstStepPanel == null) {
            throw new NullPointerException("firstStepPanel is null");
        }
        this.stepPanels = new Vector(0, 1);
        this.stepCurrent = 0;
        this.currentPanel = firstStepPanel;
        this.stepBtns = new JButton[4];
        this.stepButtons = this.stepButtonsCreate();
        this.stepLast = -1;
        this.addStepPanel(firstStepPanel);
        this.init();
    }

    public final boolean addStepPanel(WizardStepPanel nextStepPanel) {
        boolean success = false;
        if (nextStepPanel != null) {
            this.stepPanels.add(nextStepPanel);
            ++this.stepLast;
            this.stepButtonsUpdate();
            nextStepPanel.setWizardPanel(this);
        }
        return success;
    }

    public final void setNextEnable(boolean value) {
        this.stepBtns[1].setEnabled(value);
    }

    private final void init() {
        int numStepPanels = this.stepPanels.size();
        if (numStepPanels <= 0) {
            throw new IllegalStateException("call addStepPanel to add panels to show");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.stepButtons, "South");
        this.stepCurrent = 0;
        this.showCurrentStep();
    }

    private final void showCurrentStep() {
        this.stepButtonsUpdate();
        if (this.currentPanel != null) {
            this.currentPanel.setVisible(false);
            this.remove(this.currentPanel);
        }
        WizardStepPanel WSP = (WizardStepPanel)this.stepPanels.get(this.stepCurrent);
        WSP.setVisible(true);
        this.add((Component)WSP, "Center");
        this.validate();
        this.currentPanel = WSP;
    }

    private void stepButtonsUpdate() {
        this.stepBtns[0].setEnabled(this.stepCurrent != 0);
        this.stepBtns[1].setEnabled(this.stepCurrent != this.stepLast);
    }

    private final JPanel stepButtonsCreate() {
        JPanel btnPanel = new JPanel(new FlowLayout());
        int i = 0;
        while (i < this.stepBtns.length) {
            this.stepBtns[i] = new JButton();
            this.stepBtns[i].setActionCommand(this.stepBtnsStrings[i]);
            this.stepBtns[i].addActionListener(this);
            btnPanel.add(this.stepBtns[i]);
            ++i;
        }
        this.stepButtonsSetText();
        return btnPanel;
    }

    private final void stepButtonsSetText() {
        int i = 0;
        while (i < this.stepBtns.length) {
            this.stepBtns[i].setText(this.stepBtnsStrings[i]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj.getClass().isInstance(this.stepBtns[0])) {
            JButton btnSrc = (JButton)obj;
            String actionCommand = btnSrc.getActionCommand();
            if (actionCommand.equals(this.stepBtns[0].getText())) {
                --this.stepCurrent;
                this.showCurrentStep();
            } else if (actionCommand.equals(this.stepBtns[1].getText())) {
                ++this.stepCurrent;
                this.showCurrentStep();
            } else if (!actionCommand.equals(this.stepBtns[2].getText())) {
                actionCommand.equals(this.stepBtns[3].getText());
            }
        }
    }
}

