/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.ImageToolBar;
import dguitar.gui.PlayPanel;
import dguitar.gui.SongInternalFrame;
import dguitar.gui.midi.MidiInternalFrame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JToolBar;

public class PlayToolBar
extends JToolBar
implements ActionListener {
    SongInternalFrame playingSIF;
    MidiInternalFrame playingMIF;
    private boolean isSIF;
    ImageToolBar buttons;
    private PlayPanel playPanel;
    private JDesktopPane desktop;
    private boolean playing;

    public PlayToolBar(Image[] images, JDesktopPane aDesktop) {
        this.setFloatable(false);
        this.desktop = aDesktop;
        this.buttons = new ImageToolBar();
        this.buttons.setFloatable(false);
        this.buttons.setNumButtons(images.length);
        this.buttons.setImages(images);
        this.playPanel = new PlayPanel();
        this.playPanel.setAlignmentX(0.0f);
        this.buttons.add(this.playPanel);
        this.playingSIF = null;
        this.buttons.addActionListener(this);
        this.add(this.buttons);
        this.playing = false;
    }

    public void setPlaying(boolean flag) {
        this.playing = flag;
    }

    public void actionPerformed(ActionEvent arg0) {
        if (!this.playing) {
            JInternalFrame JIF = this.desktop.getSelectedFrame();
            if (JIF != null) {
                try {
                    this.playingSIF = (SongInternalFrame)this.desktop.getSelectedFrame();
                    this.isSIF = true;
                    this.playingSIF.play();
                    this.playing = true;
                }
                catch (ClassCastException cce) {
                    try {
                        this.playingMIF = (MidiInternalFrame)this.desktop.getSelectedFrame();
                        this.isSIF = false;
                        this.playingMIF.play();
                        this.playing = true;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (this.playing) {
                    this.playPanel.setSongTitle(JIF.getTitle());
                }
            }
        } else {
            if (this.isSIF) {
                this.playingSIF.stopPlaying();
            } else {
                this.playingMIF.stopPlaying();
            }
            this.playing = false;
        }
    }

    public PlayPanel getPlayPanel() {
        return this.playPanel;
    }
}

