package common;
/*
 * ImageToolBar.java
 *
 * Created on 26 de diciembre de 2004, 11:10 PM
 */

import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.Serializable;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
/**
 * @author Mauricio Gracia Gutirrez
 */
public class ImageToolBar extends JToolBar implements Serializable {
    private int numButtons ;
    private ImageIcon IconArray[] ;
    private JButton JButtonArray[] ;
    public ImageToolBar() {
        numButtons = 0 ;
        IconArray = null ;
        JButtonArray = null ;
    }
    public boolean setImages(Image images[]) {
        int i ;
        boolean success ;
        
        success = false;
        if( (images != null) && (images.length == numButtons) ) {
            if(IconArray == null) {
                IconArray = new ImageIcon[images.length] ;
            }
            for(i = 0 ; i < images.length ; i++) {
                if(images[i] != null) {
                    IconArray[i] = new ImageIcon(images[i]) ;
                    JButtonArray[i].setIcon(IconArray[i]) ;
                }
            }
            success = true ;
        }
        return success ;
    }
    public boolean setImageIcons(ImageIcon imageIcons[]) {
        int i ;
        boolean success = false;
        
        if( (imageIcons != null) && (imageIcons.length == numButtons) ) {
            IconArray = imageIcons ;
            for(i = 0 ; i < imageIcons.length ; i++) {
                if(imageIcons[i] != null) {
                    JButtonArray[i].setIcon(IconArray[i]) ;
                }
            }
            success = true ;
        }
        return success ;
    }
    
    public int getNumButtons() {
        return numButtons;
    }
    
    public void setNumButtons(int n) {
        int i ;
        
        if(n > 0) {
            numButtons = n ;
            
            JButtonArray = new JButton[numButtons] ;
            for(i = 0 ; i < numButtons ; i++) {
                JButtonArray[i] = new JButton() ;
                JButtonArray[i].setDefaultCapable(false) ;
                JButtonArray[i].setActionCommand("" + i) ;
                this.add(JButtonArray[i]) ;
            }
        }
    }
    
    public void addActionListener(ActionListener listener) {
        int i ;
        
        if(listener != null) {
            for(i = 0 ; i < numButtons ; i++) {
                JButtonArray[i].addActionListener(listener) ;
            }
        }
    }
}
