/*
 * Created on 03-mar-2005
 *
 */
package common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import javax.swing.JOptionPane;

/**
 * @author Mauricio Gracia Gutirrez
 *  
 */
public class Util {
    /** The variable that contains the error, if any */
    private static UtilErrors error = UtilErrors.NO_ERROR;

    /**
     * Checks if F is a file, if it exists and can be read
     */

    public static boolean validFile(File f) {
        boolean valid;

        error.setDetails("File passed to method validFile()");
        valid = false;
        if (f == null) {
            error = UtilErrors.PARAM_NULL;
        } else {
            if (!f.exists()) {
                error = UtilErrors.DOES_NOT_EXIST;
            } else {
                if (!f.isFile()) {
                    error = UtilErrors.NOT_A_FILE;
                } else {
                    if (!f.canRead()) {
                        error = UtilErrors.NOT_READABLE;
                    } else {
                        valid = true;
                    }
                }
            }
            error.setDetails(f.getAbsolutePath());
        }
        return (valid);
    }

    public static UtilErrors getError() {
        return error;
    }

    /*
     * 2 to the x
     */
    public static int pow2(int x) {
        int res;
        int i;

        res = 1;
        for (i = 0; i < x; i++) {
            res = 2 * res;
        }

        return res;
    }

    /**
     * Creates a String of N tabs ("\t")
     */
    public static String tabs(int n) {
        String res;
        int i;

        i = 0;
        res = "";
        for (i = 0; i < n; i++) {
            res += "\t";
        }

        return res;
    }

    public static void showDialogOk(java.awt.Component parent, String title,
            Object message) {
        JOptionPane.showMessageDialog(parent, message, title,
                JOptionPane.INFORMATION_MESSAGE);
    }

    /**
     * Closes and input stream and returns and error (null if successfull)
     */
    public static String closeIS(InputStream IS) {
        String res;

        res = null;

        if (IS != null) {
            try {
                IS.close();
            } catch (IOException IOE) {
                res = IOE.toString();
            }
        }

        return res;
    }

    /* not used yet */
    public static void waitFor(long ms) {
        try {
            Thread.sleep(ms);
        } catch (InterruptedException IE) {

        }
    }

    /**
     * 
     * 
     * @param fieldName -
     *            The name of the field to be placed in the String "Vibrato" or
     *            null
     * @param object -
     *            The object that contains the value to be placed in the String
     * @param firstField -
     *            Is this the first field ? (this is changed if both fieldName
     *            and object are not null
     * 
     * @return a string with "fieldName: object" if object is not boolean or
     *         "fieldName" otherwise.
     */
    public static String fieldFor(String fieldName, Object object,
            Boolean firstField) {
        String resp;
        Boolean booleanField;

        resp = "";
        if (object != null) {
            booleanField = new Boolean(false);
            //if its not a BOOLEAN field...then...
            if (!object.getClass().isInstance(booleanField)) {

                resp = (fieldName != null) ? fieldName + ": " : "";

                //if its the first field, start keep the RESP value
                if (firstField.booleanValue()) {
                    firstField = new Boolean(false);
                } else {
                    resp = ", " + resp;
                }
                resp += object ;
            } else {
                booleanField = (Boolean) object;
                if (booleanField.booleanValue()) {
                    firstField = new Boolean(false);
                    resp = fieldName;
                }
            }
        }
        return resp;
    }

    public static String fieldFor(String fieldName, boolean aFlag,
            Boolean firstField) {
        return fieldFor(fieldName, new Boolean(aFlag), firstField);
    }

    public static void drawLine(Graphics g , Point a, Point b) {
    	g.drawLine(a.x,a.y,b.x,b.y) ;
    }

    /**
     * Centers component C at point P, using Dim as current dimension
     * 
     * @param c - is the component
     * @param p - is the Point to center
     * @param dim - is the size of the component
     */
    public static void centerComponent(Component c, Point p, Dimension dim) {
    	if( (c != null) && (p != null) && (dim != null) ) {
    		c.setBounds(p.x - dim.width / 2, p.y - dim.height / 2, dim.width,dim.height);
    	}
    }

    public static void drawString(Graphics g, String text, Point p) {
    	g.drawString(text, p.x, p.y);
    }

    /**
     * Returns a Point were the method Util.drawString(text, Point) can be
     * called
     * 
     * @param g
     * @param aux
     * @param x
     * @param y
     * @return
     */
    public static Point centerString(Graphics g, String text, int x, int y) {
    	int dx;
    	int fontAscent;
    	Point p;
    
    	p = null;
    	if (g != null) {
    		//calculate the widht of the text
    		dx = g.getFontMetrics().stringWidth(text);
    		//calculate the font Ascent of the text
    		fontAscent = g.getFontMetrics().getAscent();
    
    		p = new Point();
    		// to center the text horizontally
    		p.x = x - dx / 2 + 1;
    		// to place the base of the font at y
    		p.y = y - fontAscent;
    	}
    	return (p);
    }
}