; LOADHI.ASM
; 
; This file contains code that loads the main program as high in conventional
; memory as possible, sets the termination address to a specific location
; within the main file, and terminates, thereby passing control to the main
; program.
;
; The main program will be appended to this file.

ASSUME CS:TEXT, DS:TEXT, SS:TEXT

TEXT SEGMENT PARA PUBLIC 'CODE'
  org 100h

start:
  jmp real_start

  magic_pattern db "#e$n%t&r/Y("
  patternlen equ $ - magic_pattern
  
  err_message db "LOADHI: Could not load the main module", 13, 10
  err_mess_len equ $ - err_message
  
  modulename db "LOADHI", 0   
  modlen equ $ - modulename

  newPSP        dw 0
  newEnv        dw 0
  paras         dw 1000h
  envSize       dw 0

errXit:
  jmp   err_term

real_start:
; resize the memory block to 64K
  mov   ah, 4ah
  mov   bx, 1000h
  int   21h
  jc    errXit
  mov   sp, 0fffeh

; get the environment segment
  cld
  mov   ax, ds:[2ch]
  or    ax, ax
  jz    noenv

; get its size, by reading the MCB size field
  dec   ax
  mov   es, ax
  mov   ax, word ptr es:[3]
  mov   envSize, ax
  
noenv:
; allocate memory for the main program
  call  AllocMem
  jc    errXit

  mov   ax, newPSP

; create a PSP for the main program
  call  copyPSP 
  
; Create an environment copy
  call  CopyEnv

; move the main program to its memory block
  push  cs
  pop   ds

  mov   si, offset prgStart
  mov   di, 100h
  mov   es, newPSP

  mov   cx, prgSize
  rep   movsb

; Now, scan for the magic pattern, to find the entry within the main program
; that will take control when this program terminates
  mov  di, 100h
  mov  cx, prgSize

again:
  mov  dx, patternLen
  dec  dx
  mov  si, offset magic_pattern
  lodsb
  repne scasb
  jne   err_term
  xchg  cx, dx
  repe  cmpsb
  xchg  cx, dx
  jne   again 
 
foundIt:
; PSP:0ah contains the address where execution will continue when this 
; program terminates
  
  mov  word ptr ds:[0ah], di
  mov  word ptr ds:[0ch], es

; mark the new process as owner of its MCB:s, so they don't get released when
; this process terminates...

  mov  ax, newPSP
  dec  ax
  mov  es, ax
  inc  ax
  mov  word ptr es:[1], ax
  mov  di, 8
  mov  cx, modlen
  mov  si, offset modulename
  rep  movsb

; if we did create an environment copy, mark that too
  mov  dx, newEnv
  or   dx, dx
  jz   term

  dec  dx
  mov  es, dx
  mov  word ptr es:[1], ax

term:
; Terminate the program, and hope for the best...
  mov  ax, 4c00h
  int  21h

err_term:
; print error message to STDERR  
  mov  dx, offset err_message
  mov  cx, err_mess_len
  mov  ax, 4000h
  mov  bx, 2
  int  21h

  mov  ax, 4cffh
  int  21h


copyPSP PROC
; reset the current PSP to this process' parent PSP,
; to make the new PSP a 'brother' of this one, rather than a child.
  mov   es, ds:[16h]

; DOS saves a process' SS:SP in this area on an int 21h call.
; Make sure that the parent process' SS:SP doesn't get overwritten
; with the current process' SS:SP

  push  es:[2eh]
  push  es:[30h]
  
  mov   bx, ds:[16h]
  mov   ah, 50h
  int   21h
  
  mov   ah, 55h
  mov   dx, newPSP
  mov   si, dx
  add   si, 1000h
  int   21h

; copy the command line info to the new PSP
  mov   si, 80h
  mov   es, newPSP
  mov   di, 80h
  mov   cx, 40h
  rep   movsw

; reset current PSP
  mov   ah, 50h
  mov   bx, ds
  int   21h

  mov   es, ds:[16h]

; restore the parent process' SS:SP save area
  pop   es:[30h]
  pop   es:[2eh]
  
  ret
copyPSP ENDP

; Allocate the necessary memory
; Turn UMB link off, set malloc strategy to 'last fit'
;
; CF set on return if error occurs.

AllocMem PROC
  mov   ax, 5802h
  int   21h
  xor   ah, ah
  mov   di, ax

  mov   ax, 5803h
  mov   bx, 0
  int   21h

  mov   ax, 5800h
  int   21h
  mov   si, ax

  mov   ax, 5801h
  mov   bx, 2
  int   21h

  mov   ah, 48h
  mov   bx, 1000h
  int   21h
  jc    dammit
  
  mov   newPSP, ax
  
  mov   ah, 48h
  mov   bx, envSize
  or    bx, bx
  jz    nada_env

  int   21h
  jc    dammit
  
  mov   newEnv, ax

nada_env:
  mov   ax, 5801h
  mov   bx, si
  int   21h

  mov   ax, 5803h
  mov   bx, di
  int   21h
  clc

dammit: 
  ret
AllocMem ENDP

; Copy the environment info.

CopyEnv PROC
  mov  dx, envSize
  or   dx, dx
  jz   no_environment

  mov  cl, 3
  shl  dx, cl

  mov  cx, dx
  mov  ds, cs:[2ch]
  mov  es, cs:newEnv

  xor  di, di
  mov  si, di
  rep  movsw 
  
; store new env
  mov  dx, es

no_environment:          
  mov  es, cs:newPSP
  mov  es:[2ch], dx
  ret
CopyEnv ENDP
  
; This variable contains the length of the main program file, and is filled
; in when appending the main program to this file.

prgSize label word 

; The actual main program file starts two bytes later
prgStart equ prgSize + 2

TEXT ENDS


END START

