/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIVS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgValString(const char * const name, char * dflt);

	Return the data of the value of the specified name parsed as string.
	If name == NULL, the currently scanned value is processed.

	Return:
		dlft: on error
		else: pointer to internal buffer with comment

ob: cfgValString
su: inifile/2
sh: Return a value as string
lo: Return the data of the specified value parsed as string.\par
	If \para{name} == NULL, the current value is processed.
va: dflt: on error
	\item else: parsed value
re:
fi: cfgivs.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIVS.C 1.3 1999/12/13 02:22:28 ska Exp ska $";
#endif

char *cfgValString(const char * const name, char * const dflt)
{
	DBG_ENTER("cfgValString", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\", dflt=\"%s\"", name, dflt) )

	chkHeap
	DBG_RETURN_BS( cfgi_parseVal(name) == 0	/* fetch and decompose the specified value */
		?	I(data)				/* success */
		:	dflt)				/* failure */
}
