/*
	Move v1.01 - Move Files Around
	Copyright (C) 1998  Jeremy Parker
	Developed: Using Borland Turbo C Version 3.00

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <string.h>
#include <alloc.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <ctype.h>
#include <errno.h>

char **exparg (int *pargc, char *argv []);
void getpname(char *source,char *pgm);
void help(char *name);
int movem(char *source, char *target);
int c_break(void);
int newfile(char *source, char *target, char *targ_fn);
int targ_there(char *target);
int copyem(char *source, char *target, char *pgm);
int same_drive(char *source, char *target);

static char version[] = {"File Move Utility, Version 1.1"};
int main(int argc,char *argv[])
{
  static char pgm[MAXFILE] = { "MOVE" };
  char target[MAXPATH];
  int i, j;

  /* get program name from DOS */
		  getpname(*argv,pgm);

		  ctrlbrk(c_break);
		  /* print opening banner for program */
		  printf("MOVE - %s\n\n",version);

  /* check for right number of arguments, give help if not */
  if (argc < 3 || strcmp(argv[1],"?") == 0) {
	 help(pgm);
			 exit(1);
	 }

		  /* uppercase everything */
		  for (i = 1; i < argc; i ++)
			 for (j = 0; j < strlen(argv[i]); j++)
				argv[i][j] = toupper(argv[i][j]);

		  /* get target */
		  strcpy(target,argv[argc - 1]);
		  --argc;

  /* if target doesn't look like a directory make it */
  if (target[strlen(target) - 1] != '\\')
	 strcat(target,"\\");

  /* check to see that the target exists */
  if (targ_there(target) != 0)
			 exit(1);


		  /* expand args */
		  argv = exparg(&argc,argv);

		  /* for each file move it */
		  for (i = 1; i < argc; i++) {
			 /* if same drive then rename should work */
			 if (same_drive(argv[i],target) == 0) {
				if (movem(argv[i],target) == 0)
				  printf("%s moved to %s\n",argv[i],target);
				else
				  printf("%s: Unable to move - %s\n",pgm,argv[i]);
				}

			 /* else copy and delete should work */
			 else {
				/* if the copy worked try to delete the source */
				if (copyem(argv[i],target,pgm) != 0)
				  printf("%s: Unable to move - %s\n",pgm,argv[i]);
				else {
				  printf("%s moved to %s\n",argv[i],target);
				  /* if the delete falied tell the user */
				  if (unlink(argv[i]) != 0)
					 printf("Unable to remove file from source directory.");
				  }
				}
			 }

  exit(0);
  return(0); // to make compiler shut up
}

int c_break(void)
{
  printf("Ctrl-Break hit. Program aborting ...\n");
  fcloseall();
  exit(1);
  return(0); // To make compiler shut up
}

void help(char *name)
{
  printf("Usage: %s source ... target\n"  \
			"where source - file(s) to be moved (wildcards allowed)\n" \
			"      target - destination directory\n\n" \
			"multiple source specications allowed\n" \
			"example - %s fu.bar file.* test*.bas \\basic\n\n",name,name);
}

void getpname(char *source,char *pgm)
{
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char ext[MAXEXT];
  int i;

  /* take apart the source */
  fnsplit(source,drive,dir,pgm,ext);

		  /* lowercase everything */
		  for(i = 0; i < strlen(pgm); i++)
			 pgm[i] = tolower(pgm[i]);
}

int targ_there(char *target)
{
  struct ffblk ffblk;
  char drive[MAXDRIVE];
  char dir[MAXDIR];
  char file[MAXFILE];
  char ext[MAXEXT];
  char targchk[MAXPATH];
  int i;

  /* take apart the source */
  fnsplit(target,drive,dir,file,ext);

  /* if we're trying to move to the root its ok */
  if (strcmp(dir,"\\") == 0)
	 return 0;

  /* copy the target to the check string and strip off the
	  trailing "\" */
  strcpy(targchk,target);
  targchk[strlen(targchk) -1] = '\0';

  /* try to find the target */
  if (findfirst(targchk,&ffblk,FA_DIREC) == 0)
	 return 0;
  else {
			 printf("target: %s\n",target);
	 return -1;
	 }
}

int same_drive(char *source, char *target)
{
  char sdrive[MAXDRIVE];
  char sdir[MAXDIR];
  char sfile[MAXFILE];
  char sext[MAXEXT];
  char tdrive[MAXDRIVE];
  char tdir[MAXDIR];
  char tfile[MAXFILE];
  char text[MAXEXT];
  char curdrive[MAXDRIVE];
  int retcode;

  /* get current drive */
  curdrive[0] = 'A' + getdisk();
  curdrive[1] = ':';
  curdrive[2] = '\0';

  /* take apart the source and target */
  fnsplit(source,sdrive,sdir,sfile,sext);
  fnsplit(target,tdrive,tdir,tfile,text);

  /* if either drive is missing put it in */
  if (strlen(sdrive) == 0)
	 strcpy(sdrive,curdrive);
  if (strlen(tdrive) == 0)
	 strcpy(tdrive,curdrive);

  /* see if the drives are the same */
  if (strcmp(sdrive,tdrive) == 0)
	 retcode = 0;
  else
	 retcode = -1;

  /* put together the source and target */
  fnmerge(source,sdrive,sdir,sfile,sext);
  fnmerge(target,tdrive,tdir,tfile,text);

		  return retcode;
}

int newfile(char *source, char *target, char *targ_fn)
{
  char sdrive[MAXDRIVE];
  char sdir[MAXDIR];
  char sfile[MAXFILE];
  char sext[MAXEXT];
  char tdrive[MAXDRIVE];
  char tdir[MAXDIR];
  char tfile[MAXFILE];
  char text[MAXEXT];
  char curdrive[MAXDRIVE];
  int flag;

  /* take apart the source */
  flag = fnsplit(source,sdrive,sdir,sfile,sext);

		  /* by this time in the program the program their should be no
			  wildcards */
		  if (flag & WILDCARDS) {
			 targ_fn = '\0';
			 return -1;
			 }

		  else {
			 /* take apart the target */
			 fnsplit(target,tdrive,tdir,tfile,text);
			 /* put together the new target filename */
			 fnmerge(targ_fn,tdrive,tdir,sfile,sext);
			 return 0;
			 }
}

int movem(char *source, char *target)
{
  char targ_fn[MAXPATH];

  /* if if we are not able to create a new_file name, bail out */
		  if (newfile(source,target,targ_fn) != 0)
			 return -1;

		  if (rename(source, targ_fn) != 0) {
			 unlink(targ_fn);
			 if (rename(source, targ_fn) != 0) {
				printf("Error moving file.");
				return -1;
				}
			 else
				return 0;
			 }
		  else
			 return 0;
}

int copyem(char *source, char *target, char *pgm)
{
  int bytes;
  FILE *input, *output;
  char iobuf[BUFSIZ];
  struct ftime instamp;
  struct ftime outstamp;
  char targ_fn[MAXPATH];
  char *outbuf;
  int temp_hand;

  /* if if we are not able to create a new_file name, bail out */
		  if (newfile(source,target,targ_fn) != 0)
			 return -1;

			if ((input = fopen(source,"rb+")) == NULL) {
			  printf("%s: Unable to open: %s\n",pgm,source);
			  fcloseall();
			  return -1;
			  }
			if ((output = fopen(targ_fn,"wb+")) == NULL) {
			  unlink(targ_fn);
			  if ((output = fopen(targ_fn,"wb+")) == NULL) {
				 printf("%s: Unable to open: %s\n",pgm,targ_fn);
				 fcloseall();
				 return -1;
					}
			  }
			  do {
				 bytes = fread(iobuf,sizeof(char),BUFSIZ,input);
				 if (ferror(input)) {
					printf("unable to move: %s\n",source);
					fclose(input);
					fclose(output);
					return -1;
					}
				 fwrite(iobuf,sizeof(char),bytes,output);
				 if (ferror(output)) {
					printf("unable to move: %s\n",source);
					fclose(input);
					fclose(output);
					return -1;
					}
				 } while(!feof(input));
			  getftime(fileno(input),&instamp);
			  outstamp = instamp;
			  fclose(input);
			  fclose(output);
			  if ((temp_hand = open(targ_fn,O_RDWR|O_BINARY)) > 0) {
				 setftime(temp_hand,&outstamp);
				 close(temp_hand);
				 }
			  return 0;
}



#define MAXARGS   100 /* maximum number of entries the new argv */
		  /* array can contain        */

#define TRUE    1
#define FALSE   0
#define NIL(type) ((type *) NULL)

typedef int BOOLEAN;

/******************************************************************************/

char **exparg (int *pargc, char *argv [])
{
  static char *newargv [MAXARGS];
  char path [MAXPATH];    /* if the stack doesn't overflow, */
  char drive [MAXDRIVE];    /* we have less lasting impact    */
  char dir [MAXDIR];    /* on the static data segment     */

  char far *olddta = getdta ();
  struct ffblk fblk;
  register int args = 0;
  register int newargc = 0;
  BOOLEAN err = FALSE;

  while (!err && args < *pargc) {
	 if ((fnsplit(argv[args],drive,dir,NIL(char),NIL(char))& WILDCARDS) &&
		 (!findfirst (argv [args], &fblk, 0))) {
		do {
		  char *localcptr = (char *)malloc (
	 (unsigned)(stpcpy (stpcpy (stpcpy (path, drive),
				 dir),
			  fblk.ff_name) - path) + 1);
		  if (localcptr != NIL(char)) {
	 newargv [newargc++] = strcpy (localcptr, path);
		  }
		  else {
	 fputs ("\n_exparg error : no memory for filenames\n", stderr);
	 exit (1);
		  }
		} while ((newargc < MAXARGS) && !findnext (&fblk));
	 }
	 else {
		newargv [newargc++] = argv [args];
	 }
	 err = (newargc == MAXARGS);
	 args++;
  }

  if (err) fputs ("\n_exparg error : too many filenames\n", stderr);
  setdta (olddta);
  *pargc = newargc;
  return (&newargv [0]);
}

