/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_RRD.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfg_rsprd(struct Cfg_Getopt *optstru, FILE * const f)

	Read the next entry from the response file and terminate program
	on error

	The ntry is stored into C(_hlen) / C(_hbuf)

ob(ject): cfg_rsprd
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Read next entry from response output file
he(ader files): 
lo(ng description): Read the next entry from a file generated by an
	output stack item.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_rrd.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "supplio.h"
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_RRD.C 1.6 1999/12/13 02:22:05 ska Exp ska $";
#endif

void cfg_rsprd(struct Cfg_Getopt *optstru, FILE * const f)
{	DBG_ENTER("cfg_rsprd", Suppl_cmdline)

	assert(optstru);
	assert(f);

	Eget(&C(_hlen), sizeof(C(_hlen)), f);
	chkHeap
	Eget(Esetsize(C(_hbuf), C(_hlen)), C(_hlen), f);
	chkHeap

	DBG_EXIT
}
