/*
    LIB - a librarian for compatible OBJ/LIB files
    Copyright (C) 1995,1996  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: TMPLIST.H 3.3 1999/02/17 05:18:08 ska Rel ska $
   $Locker: ska $	$Name: v3_2 $	$State: Rel $

	Temporary list file.

	Holds the information pair Symbol/Page#/OBJ length.

*/

#ifndef __TMPLIST_H
#define __TMPLIST_H

#include <portable.h>

struct tmpList {
	unsigned flags;	/* if TL_SIZE is set, the remaining four bytes contains */
	word pageNr;	/* the OBJ file length */
	byte symLen;
	char symbol[1];
};

#define TL_THEADR 1			/* module name */
#define TL_SIZE  2			/* size information of current OBJ */

extern unsigned minPages;	/* min amount of pages, calculated fromout the
								symbols to be written into the dir */
extern unsigned maxName;	/* longest symbol length */
extern unsigned dispInfo;	/* max. count for search heuristic */

void Sopen(void);
/* open the temporary list file.
   This file holds the symbol names and the page on which this symbol
   starts, as well as the size of the modules.
*/

void Swrite(struct tmpList *h);
/* write the symbol/page# information into the temp list file.
*/

int Sread(struct tmpList *h);
/* read the next symbol information fromout the temp list file.
	The size records are skipped.
   Return:
   	== 0, if here is no further item
   	!= 0, otherwise,& *h is filled
*/

void Srewind(void);
/* rewind temp list file. Next operation (read/write) will start
   at the first item.
*/

void Sclose(void);
/* close & delete temporary list file.
*/

void mkLstFile(char *fnam);
/* make a list file from the temporary list file.
*/

#ifdef _MICROC_
void SwriteSize(dword *size);
#else
void SwriteSize(dword size);
#endif
/* write a record into the temporary list holding the size of the
	OBJ module immediately above. */

void dispPageInfo(int update);
/* Display page size information.
	If update is != NUL, pageSizeNew will be increased. */


#endif
