/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGTYPE.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgType(struct Cfg_Getopt *optstru);

 *	Return the type of the next argument
 *
 *	Return:
 *		CFG_ARG: it's a non-option
 *		CFG_OPT: an option
 		CFG_EOF: end of argument list reached

ob(ject): cfgType
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Return the type of the currently pending argument
he(ader files): 
lo(ng description): Returns the type of the currently pending argument.
pr(erequistes): 
va(lue): CFG_ARG: non-option argument pending
	\item CFG_OPT: option pending
	\item CFG_EOF: all input stack items empty
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgtype.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGTYPE.C 1.5 2001/02/27 01:27:59 ska Exp ska $";
#endif

int cfgType(struct Cfg_Getopt *optstru)
{	Cfg_FctGetopt skipArg;

	DBG_ENTER("cfgType", Suppl_cmdline)

	assert(optstru);

	switch(C(type)) {
	default:
		/* in all other cases try to gather the next argument */
		/* we'll use getopt() to fetch the next argument */
		skipArg = C(_foundArg);
		C(_foundArg) = 0;	/* return next argument for sure */

		if(cfgGetopt(optstru))
			C(type) = CFG_OPT;
		else if(C(type) != CFG_ARG)
			C(type) = CFG_EOF;

		C(_foundArg) = skipArg;
		break;
	case CFG_EOF:		/* no more arguments */
	case CFG_ARG:		/* as long as this argument is not removed -> hang */
	case CFG_OPT:		/* there is an unused option parsed into optstru */
		break;
	}
	DBG_RETURN_I( C(type))
}
