/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIGVL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgGetValLocation(const char * const name);

	Return a code, in which INI file the value is located.
	If name == NULL, the currently scanned value is processed.

	Return:
		<0: on error
		=0: system INI file
		>0: user INI file

ob(ject): cfgGetValLocation
su(bsystem): inifile/2
sh(ort description): Return the INI file where the value is located in
lo(ng description): Return a code, in which INI file the value is
	located in.  If \para{name} == NULL, the current value is used.
va: <0: on failure
	\item =0: system INI file
	\item >0: user INI file
re(lated to): 
fi(le): cfgigvl.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIGVL.C 1.3 1999/12/13 02:22:23 ska Exp ska $";
#endif

int cfgGetValLocation(const char * const name)
{	DBG_ENTER("cfgGetValLocation", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	DBG_RETURN_BI( cfgHasValue(name) == 0	/* fetch the specified value */
		?	I(valLocation)		/* success */
		:	-1)					/* failure */
}
