/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PFIL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushFile(struct Cfg_Getopt *optstru, char *fnam)

	Push a file similiar to response files. On error the program
	is terminated. If the file could not be opened, this call is
	ignored.

	This call enables the flag to cache arguments

ob(ject): cfgPushFile
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Push a file
he(ader files): 
lo(ng description): Push a file onto the input stack. The file is opened
	immediately and kept open until the last character has been read from
	the file. This function also automatically makes sure that the current
	output stack is a large one.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pfil.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PFIL.C 1.4 1999/12/13 02:22:02 ska Exp ska $";
#endif

void cfgPushFile(struct Cfg_Getopt * const optstru, const char * const fnam)
{	DBG_ENTER("cfgPushFile", Suppl_cmdline)
	if(fnam)
		cfg_rspfile(optstru, fnam);
	DBG_EXIT
}
