/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_IS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgi_isSection(char * const line);

	Check if the line contains a section definition

ob: cfgi_isSection
ty: L
su: inifile/2
sh: Check if the specified line contains a section definition
va: NULL: line is no section
	\item else: pointer to start of name of section within the passed line
wa: The passed line is truncated at the end of the name of the section, on
	success.
re: 
fi: cfgi_is.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <ctype.h>
#include "inifile.loc"
#include "str.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_IS.C 1.4 2001/02/27 01:27:55 ska Exp ska $";
#endif

char *cfgi_isSection(char * const line)
{	char *p, *q;

	DBG_ENTER("cfgi_isSection", Suppl_inifile2)

	assert(line);

	DBG_ARGUMENTS( ("line=\"%s\"", line) )

	p = skipws(line);
	if(*p != '['			/* start of section definition */
	 || (q = strchr(p, ']')) == 0)	/* end of section */
		DBG_RETURN_S( 0)		/* no section */

	while(isspace(*--q));		/* strip trailing whitespaces */
	q[1] = '\0';
	chkHeap

	DBG_RETURN_BS( skipws(p + 1))		/* skip leading whitespaces */
}
