/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_PVA.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_putValue(char *name, int type, char *data)

	Add the value 'name' of the specified type and data into
	the already opened INI file.

ob(ject): cfgi_putValue
su(bsystem): inifile
ty(pe): LH
sy(nopsis): 
sh(ort description): Append an INI value
he(ader files): 
lo(ng description): Append a new data line into an INI file. If the name
	has already type and/or trustlevel information attached to, this
	information is retained, unless new values are specified.
pr(erequistes): 
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgi_pva.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include <ctype.h>
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_PVA.C 1.5 2001/02/27 01:27:56 ska Exp ska $";
#endif

int cfgi_putValue(const char * const name
	, int type
	, const char * const data)
{	char *newname, *p;
	int trustlevel;
	int oldtype;
	int rv;

	DBG_ENTER("cfgi_putValue", Suppl_cmdline)
	DBG_ARGUMENTS( ("name=\"%s\", typ=0x%x, data=\"%s\"", name, type, data) )

	chkHeap
	if(!name)			return CFG_ERR_ARG;

	if((newname = strdup(name)) == 0)
		DBG_RETURN_I(	CFG_ERR_MEM)

		/* copy the name and fetch the type, if any */
	chkHeap
	p = cfgi_getType(newname, &trustlevel, &oldtype);
	chkHeap
	while(--p >= newname && isspace(*p));	/* strip trailing spaces */
	p[1] = '\0';

	if(type == CFG_TNONE)
		type = oldtype;

	chkHeap
	rv = cfgCreateDataLineINI(newname, data, type, trustlevel);
	chkHeap
	free(newname);
	chkHeap

	DBG_RETURN_I( rv)
}
