/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIGVC.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgGetValComment(const char * const name);

	Return the data of the value of the specified name.
	If name == NULL, the currently scanned value is processed.

	Return:
		NULL: on error
		else: pointer to internal buffer with comment
			If no comment was specified, a pointer to "" is returned,
			which makes it impossible to differ between a comment
			of zero length and no comment at all.

ob(ject): cfgGetValComment
su(bsystem): inifile/2
sh(ort description): Return the comment of a value
lo(ng description): Return a pointer to the contents of the comment of the
 specified value with the \para{name}. If \para{name} == NULL, the current
 value is used.\par
wa: This function breaks the data of the value, so that cfgGetValData() does
 no longer work correctly.\par
 The returned string must not be modified.
va: NULL: on failure
	\item "": no or empty comment
	\item else: pointer to comment
re(lated to): 
fi(le): cfgigvc.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIGVC.C 1.4 2001/02/27 01:27:28 ska Exp ska $";
#endif

char *cfgGetValComment(const char * const name)
{	DBG_ENTER("cfgGetValComment", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	DBG_RETURN_BS( cfgi_parseVal(name) == 0	/* fetch and decompose the specified value */
		?	I(comment)			/* success */
		:	0)				/* failure */
}
