/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIGVD.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgGetValData(const char * const name);

	Return the data of the value of the specified name.
	If name == NULL, the currently scanned value is processed.

	Return:
		NULL: on error
		else: pointer to internal buffer of value name

ob(ject): cfgGetValData
su(bsystem): inifile/2
sh(ort description): Return the data of a value
lo(ng description): Return a pointer to the data of the specified value
 with the \para{name} in unmodified form. If \para{name} == NULL, the
 current value is used.
wa: This function should be called before the data (or the comment) is returned
 in any other style, because that would destroy the data.\par
 The returned string must not be modified.
va: NULL: on failure
	\item else: pointer to data
re(lated to): 
fi(le): cfgigvd.c
in(itialized by): cfgInitINI

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIGVD.C 1.4 2001/02/27 01:27:28 ska Exp ska $";
#endif

char *cfgGetValData(const char * const name)
{	DBG_ENTER("cfgGetValData", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	chkHeap
	DBG_RETURN_BS( cfgHasValue(name) == 0	/* fetch the specified value */
		?	I(data)				/* success */
		:	0)				/* failure */
}
