/*==========================[ (c) ALPHA SOFT ]==================================

FICHIER     : [dummy.c]

DATE        : 2006/02/0024 21:17:45

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/
#define __USE_LARGEFILE64
#define _LARGEFILE64_SOURCE
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <setjmp.h>
#include <unistd.h>
#include <getopt.h>

#ifdef __APPLE__
/* fopen and lseek are 64-bit aware on Mac OS X */
#define fopen64(A,B) fopen(A,B)
#define lseek64(A,B,C) lseek(A,B,C)
#endif

#define CTEST(x)		/* Traces futiles */


// extern int optind;

static jmp_buf	JmpEnv;

static void ( * StatusFunction)();

static char * FileTable =  NULL;
static int NrFile;

extern int _DvdAuthorMain(int argc,char **argv);

/*@$#[libauthor.c] static proto. AutoProtoSigV1.1. date: 106/02/27 21:33:00 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
static void ScanOpenFiles PROTO((void));
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/


/*------------------------------------------------------------------------------
	SCANOPENFILES-
Linux!jef 2006/02/27 21:30:42
------------------------------------------------------------------------------*/

static void ScanOpenFiles()
{
	int nr = sysconf( _SC_OPEN_MAX );
	int i;

	CTEST(fprintf(stderr,"OpenMax: %d\n", nr ););

	NrFile = nr;
	FileTable = malloc( nr );
	for( i = 0; i < NrFile; i++ ) {
		if( lseek64( i, 0LL, SEEK_CUR ) == -1LL ) {
			FileTable[i] = 0;
		}
		else {
			FileTable[i] = 1;
		}
	}
}
/*------------------------------------------------------------------------------
	CLOSEFILETABLE-
Linux!jef 2006/02/27 21:37:07
------------------------------------------------------------------------------*/

static void CloseFileTable()
{
	int i;
	for( i = 0; i < NrFile; i++ ) {
		if( !FileTable[i] ) {
			if( lseek64( i, 0LL, SEEK_CUR ) != -1LL ) {
				CTEST(fprintf(stderr,"ForceClose(%d)\n", i ););
				close( i );
			}
		}
	}
}
/*------------------------------------------------------------------------------
	DESTROYFILETABLE-
Linux!jef 2006/02/27 21:37:07
------------------------------------------------------------------------------*/

static void DestroyFileTable()
{
	free( FileTable );
}

/*------------------------------------------------------------------------------
	STATUS-
Linux!jef 2006/02/24 22:07:37
------------------------------------------------------------------------------*/

void AuthorStatus( char * format, ... )
{
	va_list args;
	char buffer[4096];

	va_start( args, format );
	vsnprintf( buffer, sizeof(buffer), format, args );
	if( StatusFunction ) 	(*StatusFunction)( buffer );
	va_end( args );
}
/*------------------------------------------------------------------------------
	SETSTATUSFUNCTION-
Linux!jef 2006/02/24 22:09:01
------------------------------------------------------------------------------*/

void SetStatusFunction( void (*stFun)() )
{
	StatusFunction = stFun;
}
/*------------------------------------------------------------------------------
	DVDAUTHORMAIN-
Linux!jef 2006/02/24 22:14:00
------------------------------------------------------------------------------*/

int DvdAuthorMain( int argc, char ** argv )
{
	int ret;

	ScanOpenFiles();
	ret = setjmp( JmpEnv );
	if( ret )	goto out;
	optind = 0;
	ret = _DvdAuthorMain( argc, argv );
out:;
	CloseFileTable();
	DestroyFileTable();
	return( ret );
}
/*------------------------------------------------------------------------------
	EXIT-
Linux!jef 2006/02/24 22:16:36
------------------------------------------------------------------------------*/

void Exit( int retCode )
{
	longjmp( JmpEnv, retCode );
}
/*------------------------------------------------------------------------------
	EXITAUTHOR-
Linux!jef 2006/02/24 23:02:14
------------------------------------------------------------------------------*/

void ExitAuthor()
{
	Exit( 1 );
}

