/////////////////////////////////////////////////////////////////////////////
// Name:        TitlePropDlg.h
// Purpose:     DVD title properties dialog
// Author:      Alex Thuering
// Created:     31.01.2004
// RCS-ID:      $Id: TitlePropDlg.h,v 1.15 2010/04/18 15:47:04 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef TITLE_PROP_DLG_H
#define TITLE_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"
#include "VobListBox.h"

class TitlePropDlg: public wxPropDlg {
public:
	TitlePropDlg(wxWindow *parent, DVD* dvd, int tsi, int pgci, int vobi);
	virtual ~TitlePropDlg() {}
	
private:
	DVD* m_dvd;
	int m_tsi;
	int m_pgci;
	wxArrayString* m_audioLangCodes;
	wxArrayString* m_subtitleLangCodes;
	Video* m_video;
	Pgc* m_pgc;
	Vob* m_vob;
	int m_vobi;
	VobListBox* m_vobListBox;
	wxCheckBox* m_doNotTranscodeCheckBox;
	wxButton* m_addBt;
	wxButton* m_delBt;
	wxButton* m_propBt;
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
	void CreateButtonPane(wxSizer* sizer, bool resetButton = false, bool dontShowCheckbox = false);
	/** Returns list of pre commands */
	wxArrayString GetPreCommands();
	void OnSelectItem(wxCommandEvent& event);
	void OnAddBt(wxCommandEvent& event);
	void OnRemoveBt(wxCommandEvent& event);
	void OnPropBt(wxCommandEvent& event);
	void OnAV(wxCommandEvent& event);
	void OnDoNotTranscodeCheck(wxCommandEvent& event);
	void UpdateDoNotTranscodeCheck();
	DECLARE_EVENT_TABLE()
};

#endif // TITLE_PROP_DLG_H
