/////////////////////////////////////////////////////////////////////////////
// Name:        AVPropDlg.h
// Purpose:     DVD audio/video properties dialog
// Author:      Alex Thuering
// Created:     23.02.2005
// RCS-ID:      $Id: AVPropDlg.h,v 1.4 2009/08/30 20:26:06 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef AV_PROP_DLG_H
#define AV_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

class AVPropDlg: public wxPropDlg {
public:
    AVPropDlg(wxWindow *parent, Video* video, bool menu);

private:
	Video* m_video;
	bool m_menu;
	wxString m_auto;
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
	wxString String2Auto(wxString s) { return s == _T("") ? m_auto : s; }
	wxString Auto2String(wxString s) { return s == m_auto ? _T("") : s; }
};

#endif // AV_PROP_DLG_H
