/////////////////////////////////////////////////////////////////////////////
// Name:        VideoPropDlg.cpp
// Purpose:     The video properties dialog
// Author:      Alex Thuering
// Created:     09.09.2010
// RCS-ID:      $Id: VideoPropDlg.cpp,v 1.5 2010/10/17 18:16:34 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "VideoPropDlg.h"

// begin wxGlade: ::extracode

// end wxGlade
enum {
	DST_CHOICE_ID = 2000,
	INTERLACED_CHOICE_ID,
	FF_CHOICE_ID,
	ASPECT_CHOICE_ID
};

BEGIN_EVENT_TABLE(VideoPropDlg, wxDialog)
    // begin wxGlade: VideoPropDlg::event_table
    EVT_CHOICE(DST_CHOICE_ID, VideoPropDlg::OnChangeFormat)
    EVT_CHOICE(INTERLACED_CHOICE_ID, VideoPropDlg::OnInterlaced)
    // end wxGlade
END_EVENT_TABLE()

/**
 * Constructor
 */
VideoPropDlg::VideoPropDlg(wxWindow* parent, Vob* vob, AspectRatio aspectRatio):
		wxDialog(parent, -1, wxT(""), wxDefaultPosition) {
	m_vob = vob;
	m_stream = vob->GetStreams()[0];
	m_aspectRatio = aspectRatio;
	
    // begin wxGlade: VideoPropDlg::VideoPropDlg
    m_cropBox_staticbox = new wxStaticBox(this, -1, _("Crop"));
    m_padBox_staticbox = new wxStaticBox(this, -1, _("Border"));
    m_fileNameLabel = new wxStaticText(this, wxID_ANY, _("File Name:"));
    m_fileNameText = new wxStaticText(this, wxID_ANY, wxEmptyString);
    m_durLabel = new wxStaticText(this, wxID_ANY, _("Duration:"));
    m_durText = new wxStaticText(this, wxID_ANY, wxEmptyString);
    m_srcLabel = new wxStaticText(this, wxID_ANY, _("Source format:"));
    m_srcText = new wxStaticText(this, wxID_ANY, wxEmptyString);
    m_dstLabel = new wxStaticText(this, wxID_ANY, _("Destination format:"));
    const wxString *m_dstChoice_choices = NULL;
    m_dstChoice = new wxChoice(this, DST_CHOICE_ID, wxDefaultPosition, wxDefaultSize, 0, m_dstChoice_choices, 0);
    const wxString *m_aspectChoice_choices = NULL;
    m_aspectChoice = new wxChoice(this, ASPECT_CHOICE_ID, wxDefaultPosition, wxDefaultSize, 0, m_aspectChoice_choices, 0);
    const wxString m_interlacedChoice_choices[] = {
        _("progressive"),
        _("interlaced")
    };
    m_interlacedChoice = new wxChoice(this, INTERLACED_CHOICE_ID, wxDefaultPosition, wxDefaultSize, 2, m_interlacedChoice_choices, 0);
    const wxString m_ffChoice_choices[] = {
        _("auto"),
        _("BFF"),
        _("TFF")
    };
    m_ffChoice = new wxChoice(this, FF_CHOICE_ID, wxDefaultPosition, wxDefaultSize, 3, m_ffChoice_choices, 0);
    m_padTop = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_padLeft = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_padRight = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_padBottom = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_cropTop = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_cropLeft = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_cropRight = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_cropBottom = new wxSpinCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 999);
    m_okBt = new wxButton(this, wxID_OK, _("OK"));
    m_cancelBt = new wxButton(this, wxID_CANCEL, _("Cancel"));

    set_properties();
    do_layout();
    // end wxGlade
    
    wxCommandEvent evt;
    OnChangeFormat(evt);
    m_dstChoice->SetFocus();
}


void VideoPropDlg::set_properties() {
    // begin wxGlade: VideoPropDlg::set_properties
    SetTitle(_("Video properties"));
    m_interlacedChoice->SetSelection(0);
    m_ffChoice->SetSelection(0);
    m_padTop->SetMinSize(wxSize(58, -1));
    m_padLeft->SetMinSize(wxSize(58, -1));
    m_padRight->SetMinSize(wxSize(58, -1));
    m_padBottom->SetMinSize(wxSize(58, -1));
    m_cropTop->SetMinSize(wxSize(58, -1));
    m_cropLeft->SetMinSize(wxSize(58, -1));
    m_cropRight->SetMinSize(wxSize(58, -1));
    m_cropBottom->SetMinSize(wxSize(58, -1));
    m_okBt->SetDefault();
    // end wxGlade
    
    m_fileNameText->SetLabel(m_vob->GetFilename());
    // duration
	wxString s = _("Duration:") + wxString(wxT(" "));
	if (m_vob->GetDuration()>0) {
		int secs = (int) m_vob->GetDuration();
		int mins = secs / 60;
		secs %= 60;
		int hours = mins / 60;
		mins %= 60;
		s += wxString::Format(wxT("%02d:%02d:%02d"), hours, mins, secs);
	} else
		s += wxT("N/A");
    m_durText->SetLabel(s);
    m_srcText->SetLabel(m_stream->GetSourceFormat());
    m_dstChoice->Append(DVD::GetVideoFormatLabels(true));
    m_dstChoice->SetSelection(m_stream->GetVideoFormat() - 1);
    m_aspectChoice->Append(DVD::GetAspectRatioLabels(true));
    m_aspectChoice->SetSelection(m_aspectRatio);
    m_interlacedChoice->SetSelection(m_vob->GetInterlaced() ? 1 : 0);
    m_ffChoice->SetSelection(((int)m_vob->GetFirstField()) + 1);
    while (m_vob->GetPad().size() < 4)
    	m_vob->GetPad().push_back(0);
    m_padLeft->SetValue(m_vob->GetPad()[0]);
    m_padRight->SetValue(m_vob->GetPad()[1]);
    m_padTop->SetValue(m_vob->GetPad()[2]);
    m_padBottom->SetValue(m_vob->GetPad()[3]);
    while (m_vob->GetCrop().size() < 4)
    	m_vob->GetCrop().push_back(0);
    m_cropLeft->SetValue(m_vob->GetCrop()[0]);
    m_cropRight->SetValue(m_vob->GetCrop()[1]);
    m_cropTop->SetValue(m_vob->GetCrop()[2]);
    m_cropBottom->SetValue(m_vob->GetCrop()[3]);
}


void VideoPropDlg::do_layout() {
    // begin wxGlade: VideoPropDlg::do_layout
    wxBoxSizer* mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* buttonSizer = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* propSizer = new wxFlexGridSizer(4, 2, 4, 2);
    wxBoxSizer* propSizer2 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* m_cropBox = new wxStaticBoxSizer(m_cropBox_staticbox, wxHORIZONTAL);
    wxFlexGridSizer* cropSizer = new wxFlexGridSizer(3, 3, 4, 4);
    wxStaticBoxSizer* m_padBox = new wxStaticBoxSizer(m_padBox_staticbox, wxHORIZONTAL);
    wxFlexGridSizer* padSizer = new wxFlexGridSizer(3, 3, 4, 4);
    wxBoxSizer* dstSizer = new wxBoxSizer(wxHORIZONTAL);
    propSizer->Add(m_fileNameLabel, 0, wxALIGN_CENTER_VERTICAL, 0);
    propSizer->Add(m_fileNameText, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    propSizer->Add(m_durLabel, 0, wxALIGN_CENTER_VERTICAL, 0);
    propSizer->Add(m_durText, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    propSizer->Add(m_srcLabel, 0, wxALIGN_CENTER_VERTICAL, 0);
    propSizer->Add(m_srcText, 0, wxEXPAND|wxALIGN_CENTER_VERTICAL, 0);
    propSizer->Add(m_dstLabel, 0, wxALIGN_CENTER_VERTICAL, 0);
    dstSizer->Add(m_dstChoice, 0, wxALIGN_CENTER_VERTICAL, 0);
    dstSizer->Add(m_aspectChoice, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 6);
    dstSizer->Add(m_interlacedChoice, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 6);
    dstSizer->Add(m_ffChoice, 0, wxLEFT|wxALIGN_CENTER_VERTICAL, 6);
    propSizer->Add(dstSizer, 1, wxEXPAND, 0);
    propSizer->Add(20, 20, 0, wxEXPAND, 0);
    padSizer->Add(8, 8, 0, 0, 0);
    padSizer->Add(m_padTop, 0, 0, 0);
    padSizer->Add(8, 8, 0, 0, 0);
    padSizer->Add(m_padLeft, 0, 0, 0);
    padSizer->Add(8, 8, 0, 0, 0);
    padSizer->Add(m_padRight, 0, 0, 0);
    padSizer->Add(8, 8, 0, 0, 0);
    padSizer->Add(m_padBottom, 0, 0, 0);
    padSizer->Add(8, 8, 0, 0, 0);
    m_padBox->Add(padSizer, 1, wxALL, 4);
    propSizer2->Add(m_padBox, 0, wxRIGHT|wxEXPAND, 6);
    cropSizer->Add(8, 8, 0, 0, 0);
    cropSizer->Add(m_cropTop, 0, 0, 0);
    cropSizer->Add(8, 8, 0, 0, 0);
    cropSizer->Add(m_cropLeft, 0, 0, 0);
    cropSizer->Add(8, 8, 0, 0, 0);
    cropSizer->Add(m_cropRight, 0, 0, 0);
    cropSizer->Add(8, 8, 0, 0, 0);
    cropSizer->Add(m_cropBottom, 0, 0, 0);
    cropSizer->Add(8, 8, 0, 0, 0);
    m_cropBox->Add(cropSizer, 1, wxALL, 4);
    propSizer2->Add(m_cropBox, 0, wxEXPAND, 0);
    propSizer2->Add(2, 2, 1, wxEXPAND, 0);
    propSizer->Add(propSizer2, 1, wxLEFT|wxRIGHT|wxTOP|wxEXPAND, 6);
    propSizer->AddGrowableRow(2);
    propSizer->AddGrowableCol(1);
    mainSizer->Add(propSizer, 0, wxALL|wxEXPAND, 10);
    mainSizer->Add(4, 4, 1, wxEXPAND, 0);
    buttonSizer->Add(10, 10, 1, wxEXPAND, 0);
    buttonSizer->Add(m_okBt, 0, 0, 0);
    buttonSizer->Add(8, 8, 0, 0, 0);
    buttonSizer->Add(m_cancelBt, 0, 0, 0);
    buttonSizer->Add(10, 10, 1, wxEXPAND, 0);
    mainSizer->Add(buttonSizer, 0, wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND, 4);
    SetSizer(mainSizer);
    mainSizer->Fit(this);
    Layout();
    Centre();
    // end wxGlade
}

/**
 * Displays dialog
 */
int VideoPropDlg::ShowModal() {
	int res = wxDialog::ShowModal();
	if (res == wxID_OK) {
		m_stream->SetDestinationFormat(m_dstChoice->GetSelection() + 1);
		m_vob->GetPad()[0] = m_padLeft->GetValue();
		m_vob->GetPad()[1] = m_padRight->GetValue();
		m_vob->GetPad()[2] = m_padTop->GetValue();
		m_vob->GetPad()[3] = m_padBottom->GetValue();
		m_vob->GetCrop()[0] = m_cropLeft->GetValue();
		m_vob->GetCrop()[1] = m_cropRight->GetValue();
		m_vob->GetCrop()[2] = m_cropTop->GetValue();
		m_vob->GetCrop()[3] = m_cropBottom->GetValue();
		m_vob->SetInterlaced(m_interlacedChoice->GetSelection() == 1);
		m_vob->SetFirstField((FirstField) (m_ffChoice->GetSelection() - 1));
		m_aspectRatio = (AspectRatio) m_aspectChoice->GetSelection();
	}
	return res;
}

// wxGlade: add VideoPropDlg event handlers
void VideoPropDlg::OnChangeFormat(wxCommandEvent &event) {
	bool enable = m_dstChoice->GetSelection() > 0;
	m_interlacedChoice->Enable(enable);
	m_cropBox_staticbox->Enable(enable);
	m_padBox_staticbox->Enable(enable);
	m_padLeft->Enable(enable);
	m_padRight->Enable(enable);
	m_padTop->Enable(enable);
	m_padBottom->Enable(enable);
	m_cropLeft->Enable(enable);
	m_cropRight->Enable(enable);
	m_cropTop->Enable(enable);
	m_cropBottom->Enable(enable);
	if (m_dstChoice->GetSelection() == 0) {
		m_interlacedChoice->SetSelection(0);
		m_padLeft->SetValue(0);
		m_padRight->SetValue(0);
		m_padTop->SetValue(0);
		m_padBottom->SetValue(0);
		m_cropLeft->SetValue(0);
		m_cropRight->SetValue(0);
		m_cropTop->SetValue(0);
		m_cropBottom->SetValue(0);
	}
	wxCommandEvent evt;
	OnInterlaced(evt);
}

void VideoPropDlg::OnInterlaced(wxCommandEvent &event) {
	m_ffChoice->Enable(m_interlacedChoice->GetSelection() == 1);
	if (m_interlacedChoice->GetSelection() == 0)
		m_ffChoice->SetSelection(0);
}
