/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpcDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateVpc
extends BaseCmd {
    private String cidr;

    public CreateVpc(String[] args) {
        super("ec2addvpc", "ec2-create-vpc");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "CIDR";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a VPC with the CIDR block you specify. The CIDR parameter is a");
        System.out.println("     valid CIDR block, e.g. 10.0.2.0/24.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.cidr = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.createVpc(this.cidr);
        out.output(System.out, (VpcDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
        this.assertNonOptionSet("CIDR");
        this.warnIfTooManyNonOptions();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new CreateVpc(args).invoke();
    }
}

