/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteCustomerGateway
extends BaseCmd {
    private String customerGatewayId;

    public DeleteCustomerGateway(String[] args) {
        super("ec2delcgw", "ec2-delete-customer-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "CUSTOMER_GATEWAY";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a customer gateway. You must delete the VPN connection before");
        System.out.println("     deleting the customer gateway. The CUSTOMER_GATEWAY parameter is the");
        System.out.println("     ID of the customer gateway you want to delete.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.customerGatewayId = this.getNonOptions()[0];
        RequestResultPair rsp = jec2.deleteCustomerGateway(this.customerGatewayId);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputObjectId(System.out, "CUSTOMERGATEWAY", this.customerGatewayId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("CUSTOMER_GATEWAY");
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DeleteCustomerGateway(args).invoke();
    }
}

