/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.License;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeLicenses
extends BaseCmd {
    public DescribeLicenses(String[] args) {
        super("ec2dlic", "ec2-describe-licenses");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    protected String getOptionString() {
        return "[LICENSE [LICENSE [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your licenses");
        System.out.println("     The LICENSE parameter is the license ID(s) to describe.");
        System.out.println("     If unspecified all your licenses will be returned.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] licenseIds = this.getNonOptions();
        RequestResultPair rsp = jec2.describeLicenses(this.getFilters(true), licenseIds);
        for (License license : (List)rsp.getResponse()) {
            out.output(System.out, license);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeLicenses(args).invoke();
    }
}

