/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2Impl;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.vmconversion.DiskImageVerifier;
import com.amazon.aes.webservices.client.vmconversion.ImageFormatVerifier;
import com.amazon.aes.webservices.client.vmconversion.Location;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversion.VerifierFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class CreateConversionTask
extends BaseCmd {
    public static final String[] SUPPORTED_FORMATS = new String[]{"VMDK", "RAW"};
    public static final int MAX_COMMENT_LENGTH = 255;
    public static final long ONE_GIG = 0x40000000L;
    public static final String FORMAT_DESC = "The file format of the disk image (one of VMDK or RAW).  [REQUIRED]";
    public static final String DISK_IMAGE_DESC = "Specifies the local file name of the disk image to be imported. [REQUIRED]";
    public static final String[] DESCRIPTION_DESC = new String[]{"An optional, free-form comment that will be returned verbatim during", "subsequent calls to ec2-describe-conversion-tasks.  Maximum length is 255", "characters."};
    public static final String[] VOLUME_DASH_SIZE_DESC = new String[]{"The size of the EBS volume, in GiB (2^30 bytes), that will hold the", "converted image. If this option is omitted, the required volume size", "will be computed from the image file."};
    public static final String[] OWNER_SAK_DESC_ = new String[]{"AWS Secret Access Key of the owner of BUCKET, used to sign the import", "-manifest URL. This parameter value is not sent to EC2. [REQUIRED]"};
    public static final String[] BUCKET_DESC = new String[]{"S3 destination bucket name for the manifest. [REQUIRED, unless the option", "--manifest-url is specified]"};
    public static final String[] PREFIX_DESC = new String[]{"Prefix for the manifest-file and disk-image file parts within the S3", "bucket. [OPTIONAL]"};
    public static final String[] IMPORT_URL_DESC = new String[]{"Optionally, specify the URL for an existing import-manifest file already", "uploaded to S3 [OPTIONAL]. This option cannot be specified if --bucket", "has been specified."};
    public static final String[] IGNORE_REGION_AFFINITY_DESC = new String[]{"Ignore the verification check to determine that the bucket's S3 region", "matches the EC2 region where the conversion-task is created."};
    public static final String[] BUCKET_ATTRIBUTE_ARGS = new String[]{"bucket", "manifest-url"};
    public static final String[] DONT_VERIFY_FORMAT_DESC = new String[]{"Do not verify the file format.  This is dangerous and may result in a failed", "conversion. USE AT YOUR OWN RISK."};
    public static final int DEFAULT_EXPIRATION = 30;
    public static final String EXPIRES_ARG = "DAYS";
    public static final String[] EXPIRES_DESC = new String[]{"Validity period for the signed S3 URLS that allow EC2 to access the manifest", "Defaults to 30 days. [OPTIONAL]"};
    protected String az;
    protected File image;
    protected String diskImageFormat;
    protected long diskImageSize;
    protected int volumeSize;
    protected String signedManifestUrl;
    protected URL manifestUrl;
    protected String description;
    protected String s3AccessId;
    protected String s3SecretKey;
    protected S3Service s3Service;
    protected String bucket;
    protected String prefix;
    protected boolean verifyRegion;
    protected boolean verifyFormat;

    public CreateConversionTask(String short_form, String long_form) {
        super(short_form, long_form);
    }

    public CreateConversionTask(String short_form, String[] long_form) {
        super(short_form, long_form);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FORMAT");
        OptionBuilder.withDescription((String)this.joinDescription(FORMAT_DESC));
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"description");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DESCRIPTION");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(DESCRIPTION_DESC));
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"volume-size");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SIZE");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(VOLUME_DASH_SIZE_DESC));
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"OWNERAKID");
        OptionBuilder.withDescription((String)this.joinDescription("AWS Access Key Id of the owner of BUCKET."));
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECRETKEY");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(OWNER_SAK_DESC_));
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)"bucket");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"BUCKET");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(BUCKET_DESC));
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withLongOpt((String)"prefix");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"PREFIX");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(PREFIX_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"manifest-url");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(IMPORT_URL_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"ignore-region-affinity");
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(IGNORE_REGION_AFFINITY_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"expires");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)EXPIRES_ARG);
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(EXPIRES_DESC));
        options.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withLongOpt((String)"dont-verify-format");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(DONT_VERIFY_FORMAT_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] disk-image";
    }

    public void printOptions() {
        super.printOptions(true);
    }

    public void printDescription() {
        super.printDescription();
    }

    protected boolean isValidFormat(String fmt) {
        for (String validFormat : SUPPORTED_FORMATS) {
            if (!validFormat.equalsIgnoreCase(fmt)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAndSetVolumeSize() throws VerificationException {
        if (this.isOptionSet("volume-size")) {
            try {
                this.volumeSize = Integer.parseInt(this.getOptionValue("volume-size"));
                if (!this.verifyFormat) return;
                DiskImageVerifier verifier = new DiskImageVerifier(this.image);
                verifier.validateImageFormat(this.diskImageFormat, this.volumeSize);
                return;
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument("volume-size", this.getOptionValue("volume-size"));
            }
        } else {
            VerifierFactory factory = new VerifierFactory(this.diskImageFormat);
            ImageFormatVerifier verifier = factory.getVerifier(this.image);
            long actualConvertedSize = verifier.convertedSize();
            this.volumeSize = (int)Math.ceil((double)actualConvertedSize / 1.073741824E9);
            System.out.println("Requesting volume size: " + this.volumeSize + " GB");
        }
    }

    protected Location getEC2BucketLocation() throws GeneralError {
        try {
            URL url = new URL(this.getURL());
            Jec2Impl jec2 = new Jec2Impl(url, this.getOptionValue("private-key"), this.getOptionValue("cert"));
            String ec2Url = url.toExternalForm();
            String regionName = null;
            RequestResultPair rsp = jec2.describeRegions(new LinkedList(), null);
            for (RegionDescription d : (List)rsp.getResponse()) {
                if (!ec2Url.contains(d.name)) continue;
                regionName = d.name;
                break;
            }
            String locationStr = regionName == null ? null : regionName.replaceAll("-", "_").toUpperCase();
            return Location.fromGenericValue(locationStr);
        }
        catch (Exception e) {
            throw new GeneralError("Error determining EC2 region " + e);
        }
    }

    protected void createSignedManifestUrl() throws GeneralError, VerificationException {
        try {
            ManifestFactory mf = new ManifestFactory(this.s3Service);
            int expires = this.isOptionSet("expires") ? Integer.parseInt(this.getOptionValue("expires")) : 30;
            Location location = this.getEC2BucketLocation();
            this.signedManifestUrl = this.manifestUrl != null ? mf.createSignedManifestUrl(this.image, this.manifestUrl, location, expires, this.verifyRegion) : mf.createSignedManifestUrl(this.image, this.bucket, location, this.prefix, expires, this.verifyRegion);
        }
        catch (S3ServiceException e) {
            throw new GeneralError("ERROR: Unable to create signed manifest URL. " + e.getMessage());
        }
    }

    protected void validateImageAndFormat() {
        try {
            this.image = new File(this.getNonOptions()[0]);
            this.warnIfTooManyNonOptions();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GeneralError("Required argument disk-image missing (-h for usage). ");
        }
        if (!this.image.exists()) {
            throw new GeneralError("File " + this.image + " does not exist");
        }
        this.assertOptionSet("format");
        this.diskImageFormat = this.getOptionValue("format").toUpperCase();
        if (!this.isValidFormat(this.diskImageFormat)) {
            throw new InvalidArgument("format", this.getOptionValue("format"));
        }
    }

    public void validateAndSetupS3Access() throws GeneralError {
        this.assertOptionSet("owner-akid");
        this.s3AccessId = this.getOptionValue("owner-akid");
        this.assertOptionSet("owner-sak");
        this.s3SecretKey = this.getOptionValue("owner-sak");
        try {
            this.s3Service = new RestS3Service((ProviderCredentials)new AWSCredentials(this.s3AccessId, this.s3SecretKey));
        }
        catch (S3ServiceException e) {
            throw new GeneralError("Error accessing S3 with the given user credentials. " + e.getMessage());
        }
    }

    public void getBucketParameters() throws GeneralError {
        this.assertOnlyOneOptionSet(BUCKET_ATTRIBUTE_ARGS);
        if (this.isOptionSet("bucket")) {
            this.bucket = this.getOptionValue("bucket");
            this.prefix = this.isOptionSet("prefix") ? this.getOptionValue("prefix") : null;
            this.manifestUrl = null;
        } else {
            try {
                this.manifestUrl = new URL(this.getOptionValue("manifest-url"));
            }
            catch (MalformedURLException e) {
                throw new GeneralError("The manifest-url " + this.getOptionValue("manifest-url") + " is not well formed");
            }
            this.bucket = null;
            this.prefix = "";
        }
    }

    protected void validateParameters() throws GeneralError, VerificationException {
        this.verifyRegion = !this.isOptionSet("ignore-region-affinity");
        this.verifyFormat = !this.isOptionSet("dont-verify-format");
        this.validateImageAndFormat();
        this.validateAndSetVolumeSize();
        this.validateAndSetupS3Access();
        this.getBucketParameters();
        this.description = this.getOptionValue("description");
        if (this.description != null && this.description.length() > 255) {
            throw new InvalidArgument("description", this.description);
        }
    }
}

