/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservedInstancesDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeReservedInstances
extends BaseCmd {
    public DescribeReservedInstances(String[] args) {
        super("ec2dri", "ec2-describe-reserved-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        result.addOption(OptionBuilder.create((String)"F"));
        return result;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe purchased reserved instances offerings");
        System.out.println("     If no reserved instanced IDs are specified, all purchased reserved instances will be listed.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeReservedInstances(Arrays.asList(this.getNonOptions()), this.getFilters(true));
        for (ReservedInstancesDescription option : (List)rsp.getResponse()) {
            out.output(System.out, option);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected String getOptionString() {
        return "[RESERVED-INSTANCES-ID [RESERVED-INSTANCES-ID [...]]]";
    }

    public static void main(String[] args) {
        new DescribeReservedInstances(args).invoke();
    }
}

