/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import java.util.HashMap;
import org.jets3t.service.model.S3Bucket;

public class Location {
    protected static final HashMap<String, String> locationMap = new HashMap<String, String>(){
        {
            this.put("US_EAST_1", S3Bucket.LOCATION_US);
            this.put("EU_WEST_1", "EU");
            this.put("AP_SOUTHEAST_1", "ap-southeast-1");
            this.put("AP_NORTHEAST_1", "ap-northeast-1");
            this.put("US_WEST_1", "us-west-1");
        }
    };
    protected final String s3Value;
    protected final String genericValue;

    public String getGenericValue() {
        return this.genericValue;
    }

    private Location(String genericValue, String s3Value) {
        this.s3Value = s3Value;
        this.genericValue = genericValue;
    }

    public static Location fromGenericValue(String genericVal) {
        String genVal = locationMap.containsKey(genericVal) ? genericVal : "US_EAST_1";
        return new Location(genVal, locationMap.get(genVal));
    }

    public static Location fromS3Value(String s3Val) {
        String genVal = null;
        if (s3Val != null) {
            for (String loc : locationMap.keySet()) {
                if (!s3Val.equals(locationMap.get(loc))) continue;
                genVal = loc;
                break;
            }
        }
        Location locatn = Location.fromGenericValue(genVal);
        return locatn;
    }

    public String getS3Value() {
        return this.s3Value;
    }

    public boolean equals(Location loc) {
        return this.genericValue.equals(loc.genericValue);
    }

    public String toString() {
        return this.genericValue;
    }
}

